% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/js.R
\name{activate_js}
\alias{activate_js}
\alias{invoke_js}
\title{Interact with JavaScript built-in Functions}
\usage{
activate_js()

invoke_js(fun, ui_ref, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{fun}{JS function to be invoked.}

\item{ui_ref}{The UI reference to call the JS function on.}

\item{session}{The shiny session within which to call \code{sendCustomMessage}.

\describe{
\item{show}{Show an element with the jQuery selector provided.}
\item{hide}{Hide an element with the jQuery selector provided.}
\item{showid}{Show an element with the id provided.}
\item{hideid}{Hide an element with the id provided.}
\item{showclass}{Same as showid, but with class.}
\item{hideclass}{Same as hideid, but with class.}
\item{showhref}{Same as showid, but with \code{a[href*=}}
\item{hidehref}{Same as hideid, but with \code{a[href*=}}
\item{clickon}{Click on an element. The full jQuery selector has to be used.}
\item{disable}{Add "disabled" to an element. The full jQuery selector has to be used.}
\item{reable}{Remove "disabled" from an element. The full jQuery selector has to be used.}
}}
}
\description{
\code{activate_js} is used in your UI to insert directly the JavaScript
functions contained in golem. These functions can be called from
the server with \code{invoke_js}. \code{invoke_js} can also be used
to lauch any JS function created inside a Shiny JavaScript handler.
}
