% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{wave_variance}
\alias{wave_variance}
\title{Generate a Wave Variance for a Univariate Time Series}
\usage{
wave_variance(signal_modwt_bw, robust = FALSE, eff = 0.6)
}
\arguments{
\item{signal_modwt_bw}{A \code{field<vec>} that contains the brick walled modwt or dwt decomposition}

\item{robust}{A \code{boolean} to determine the type of wave estimation.}

\item{eff}{A \code{double} that indicates the efficiency.}
}
\value{
A \code{vec} that contains the wave variance.
}
\description{
Computes an estimate of the wave variance
}
\examples{
set.seed(1337)
x = rnorm(100)
decomp = modwt_cpp(x, filter_name = "haar", nlevels = 4, boundary = "periodic", brickwall = TRUE)
wave_variance(decomp)

wave_variance(decomp, robust = TRUE, eff = 0.6)
}
\keyword{internal}

