% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modwt.R
\name{brickwall}
\alias{brickwall}
\title{Brickwall functionality for MO/DWT}
\usage{
brickwall(signal.decomp)
}
\arguments{
\item{signal.decomp}{A \code{modwt} or \code{dwt} object that has not yet been brick walled}
}
\value{
A \code{modwt} or \code{dwt} object that has been brick walled
}
\description{
Removes boundary coefficients
}
\examples{
set.seed(999)
x = rnorm(100)
o = modwt(x, bw = FALSE)
brickwall(o)

x = rnorm(2^8)
j = dwt(x, bw = FALSE)
brickwall(j)
}
\author{
JJB
}

