% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{sortDataInGrid}
\alias{sortDataInGrid}
\title{Reorder data in a grid}
\usage{
sortDataInGrid(
  x,
  grid = attr(x, "grid"),
  orderIn = attr(x, "gridOrder"),
  orderOut = list(refpoint = "bottomleft", cycle = 1:2)
)
}
\arguments{
\item{x}{gridded data}

\item{grid}{grid topology underlying}

\item{orderIn}{current ordering description (see \code{\link[=setGridOrder]{setGridOrder()}})}

\item{orderOut}{desired output ordering description (see \code{\link[=setGridOrder]{setGridOrder()}})}
}
\value{
the data from \code{x} (typically a matrix), but reordered as \code{orderOut}
}
\description{
Reorder the data in a compact grid, changing between ordering specifications
}
\examples{
\dontrun{
getTellus(cleanup=TRUE, TI=TRUE)
load("Tellus_TI.RData")
coords = as.matrix(Tellus_TI[,1:2])
compo = compositions::acomp(Tellus_TI[,3:7])
dt = spatialGridAcomp(coords=coords, compo=compo)
image_cokriged(dt, ivar="MgO", breaks = NULL) 
x = sort(unique(coords[,1]))
y = sort(unique(coords[,2]))
x0 = c(min(x), min(y))
Ax = c(mean(diff(x)), mean(diff(y)))
n = c(length(x), length(y))
gr = sp::GridTopology(cellcentre.offset=x0, cellsize=Ax, cells.dim=n)
dt0 = sortDataInGrid(Tellus_TI, grid=gr, orderIn=gridOrder_array(2), 
                    orderOut=list(refpoint="bottomright", cycle=2:1))
coords = as.matrix(dt0[,1:2])
compo = compositions::acomp(dt0[,3:7])
spatialGridAcomp(coords=coords, compo=compo)
}
}
\seealso{
\code{\link[=setGridOrder]{setGridOrder()}} for ways of specifying the grid ordering
}
