% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{setMask}
\alias{setMask}
\alias{setMask.default}
\alias{setMask.data.frame}
\alias{setMask.DataFrameStack}
\alias{setMask.SpatialGrid}
\alias{setMask.GridTopology}
\alias{setMask.SpatialPoints}
\title{Set a mask on an object}
\usage{
setMask(x, ...)

\method{setMask}{default}(x, mask, coordinates = 1:2, ...)

\method{setMask}{data.frame}(x, mask, coordinates = 1:2, ...)

\method{setMask}{DataFrameStack}(x, mask, coordinates = attr(x, "coordinates"), ...)

\method{setMask}{SpatialGrid}(x, mask, ...)

\method{setMask}{GridTopology}(x, mask, ...)

\method{setMask}{SpatialPoints}(x, mask, ...)
}
\arguments{
\item{x}{an object to mask (for set) or masked (for get)}

\item{...}{extra arguments for generic compatibility}

\item{mask}{the mask to impose on \code{x}}

\item{coordinates}{for some of the methods, it is important to specify the names or indices
of the columns containing the geographic coordinates (only \code{setMask.data.frame}) or else
to specify the matrix of spatial coordinates (all \code{setMask} methods including it)}
}
\value{
The object \code{x} appropriately masked (for the setter methods).
}
\description{
Set a mask on an object See \code{\link[=constructMask]{constructMask()}} for examples on how to construct masks.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Set a mask on an object

\item \code{data.frame}: Set a mask on a data.frame object

\item \code{DataFrameStack}: Set a mask on a DataFrameStack object

\item \code{SpatialGrid}: Set a mask on a SpatialGrid object

\item \code{GridTopology}: Set a mask on a GridTopology object

\item \code{SpatialPoints}: Set a mask on a SpatialPoints object
}}

\seealso{
Other masking functions: 
\code{\link{constructMask}()},
\code{\link{getMask}()},
\code{\link{print.mask}()},
\code{\link{unmask}()}
}
\concept{masking functions}
