% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionsCompatibility.R
\name{plot.logratioVariogramAnisotropy}
\alias{plot.logratioVariogramAnisotropy}
\title{Plot variogram lines of empirical directional logratio variograms}
\usage{
\method{plot}{logratioVariogramAnisotropy}(
  x,
  azimuths = colnames(x),
  col = rev(rainbow(length(azimuths))),
  type = "o",
  V = NULL,
  lty = 1,
  pch = 1:length(azimuths),
  model = NULL,
  figsp = 0,
  closeplot = TRUE,
  ...
)
}
\arguments{
\item{x}{logratio variogram with anisotropy, i.e. object of class c("logratioVariogramAnisotropy", "logratioVariogram")}

\item{azimuths}{which directions do you want to plot? default: all directions available}

\item{col}{colors to be used for plotting}

\item{type}{type of representation, see \code{\link[graphics:plot]{graphics::plot()}}}

\item{V}{optionally, a matrix of logcontrasts, or else one of the following strings: "alr", "ilr" or "clr";
to produce a plot of the empirical variogram in the corresponding representation; default to variation-variograms}

\item{lty}{style of the lines, potentially different for each directions}

\item{pch}{symbols for the points, potentially different for each directions}

\item{model}{eventually, variogram model to plot on top of the empirical variogram}

\item{figsp}{spacing between the several panels, if desired}

\item{closeplot}{boolean, should the plotting par() be returned to the starting values? (defaults to TRUE;
see \code{plot.gmCgram()} for details)}

\item{...}{additional graphical arguments, to be passed to the underlying \code{\link[graphics:matplot]{graphics::matplot()}}
function}
}
\value{
Nothing. The function is called to create a plot.
}
\description{
Plots an "logratioVariogramAnisotropy" object in a series of panels, with each direction
represented as a broken line.
}
\examples{
data("jura", package="gstat")
X = jura.pred[,1:2]
Zc = compositions::acomp(jura.pred[,7:9])
vg = logratioVariogram(data=Zc, loc=X, azimuth=c(0:3)*45, 
                         azimuth.tol=22.5)
plot(vg) 
}
