% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-inlines.R
\name{md_bold}
\alias{md_bold}
\title{Markdown bold emphasis}
\usage{
md_bold(x)
}
\arguments{
\item{x}{The text to be emphasized in bold.}
}
\value{
A \code{glue} vector of length equal to \code{x}.
}
\description{
Take a character vector and wrap each element in double asterisks to create a
glue vector of bold emphasis text. This inline is rendered as the \verb{<stong>}
HTML tag.
}
\details{
A double \verb{**} or \verb{__} can open or close emphasis... Emphasis begins with a
delimiter that can open emphasis and ends with a delimiter that can close
emphasis, and that uses the same character (\verb{__} or \verb{**}) as the opening
delimiter.
}
\examples{
md_bold("Example")
md_bold(state.name)
}
\seealso{
Other inline functions: 
\code{\link{md_autolink}()},
\code{\link{md_code}()},
\code{\link{md_convert}()},
\code{\link{md_disallow}()},
\code{\link{md_escape}()},
\code{\link{md_hardline}()},
\code{\link{md_image}()},
\code{\link{md_issue}()},
\code{\link{md_italic}()},
\code{\link{md_link}()},
\code{\link{md_softline}()},
\code{\link{md_strike}()},
\code{\link{md_text}()}
}
\concept{inline functions}
