% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{FisherScoring}
\alias{FisherScoring}
\title{Fisher Scoring algorithm in Generalized Linear Models}
\usage{
FisherScoring(object, verbose = TRUE, digits = 10)
}
\arguments{
\item{object}{one object of the class \emph{glm}.}

\item{verbose}{an (optional) logical indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{digits}{an (optional) integer value indicating the number of decimal places to be used. By default, \code{digits} is set to be 10.}
}
\value{
a matrix whose first three columns are the following
\tabular{ll}{
\code{Iteration} \tab the iteration number,\cr
\tab \cr
\code{Deviance} \tab value of the (unscaled) deviance computed using the current value of the parameter vector,\cr
\tab \cr
\code{Tolerance} \tab value of \eqn{|deviance-deviance_{old}|/(deviance_{old} + 0.1)},\cr
}
}
\description{
This function displays the entire path performed by the Fisher Scoring
algorithm for the parameter estimation in Generalized Linear Models, from the
starting value until the convergence is achieved or the maximum number of iterations
is exceed.
}
\examples{
###### Example 1: Fuel efficiency of cars
Auto <- ISLR::Auto
fit1 <- glm(mpg ~ horsepower + weight + horsepower*weight, family=Gamma(inverse), data=Auto,
            control=list(trace=TRUE))
FisherScoring(fit1)

###### Example 2: Hill races in Scotland
data(races)
fit2 <- glm(rtime ~ log(distance) + log(cclimb), family=Gamma(log), data=races,
            control=list(trace=TRUE))
FisherScoring(fit2)

###### Example 3:
burn1000 <- aplore3::burn1000
burn1000 <- within(burn1000, death <- factor(death, levels=c("Dead","Alive")))
fit3 <- glm(death ~ age*inh_inj + tbsa*inh_inj, family=binomial("logit"), data=burn1000,
            control=list(trace=TRUE))
FisherScoring(fit3)

###### Example 4: Skin cancer in women
data(skincancer)
fit4 <- glm(cases ~ offset(log(population)) + city + age, family=poisson, data=skincancer,
            control=list(trace=TRUE))
FisherScoring(fit4)

###### Example 5: Agents to stimulate cellular differentiation
data(cellular)
fit5 <- glm(cbind(cells,200-cells) ~ tnf + ifn, family=binomial(logit), data=cellular,
            control=list(trace=TRUE))
FisherScoring(fit5)

###### Example 6: Advertising
data(advertising)
fit6 <- glm(sales ~ log(TV) + radio + log(TV)*radio, family=gaussian(log), data=advertising,
            control=list(trace=TRUE))
FisherScoring(fit6)

}
