% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{overglm}
\alias{overglm}
\title{Alternatives to the Poisson and Binomial Regression Models under the presence of Overdispersion.}
\usage{
overglm(
  formula,
  family = "nb1(log)",
  weights,
  data,
  subset,
  na.action = na.omit(),
  reltol = 1e-13,
  start = NULL,
  ...
)
}
\arguments{
\item{formula}{a \code{formula} expression of the form \code{response ~ x1 + x2 + ...}, which is a symbolic description
of the linear predictor of the model to be fitted to the data.}

\item{family}{a character string which allows to specify the distribution to describe the response variable, as well as the link
function to be used in the model for \eqn{\mu}. The following distributions are supported: negative binomial I ("nb1"),
negative binomial II ("nb2"), negative binomial ("nbf"), zero-truncated negative binomial I ("ztnb1"),
zero-truncated negative binomial II ("ztnb2"), zero-truncated negative binomial ("ztnbf"), zero-truncated
poisson ("ztpoi"), beta-binomial ("bb") and random-clumped binomial ("rcb"). Link functions available for
these models are the same than those available
in Poisson and binomial models via \link{glm}. See \link{family} documentation.}

\item{weights}{an (optional) vector of positive "prior weights" to be used in the fitting process. The length of
\code{weights} should be the same as the number of observations.}

\item{data}{an (optional) \code{data frame} in which to look for variables involved in the \code{formula} expression,
as well as for variables specified in the arguments \code{weights} and \code{subset}.}

\item{subset}{an (optional) vector specifying a subset of individuals to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain NAs. By default \code{na.action}
is set to be \code{na.omit()}.}

\item{reltol}{an (optional) positive value which represents the \emph{relative convergence tolerance} for the BFGS method in \link{optim}.
By default, \code{reltol} is set to be 1e-13.}

\item{start}{an (optional) vector of starting values for the parameters in the linear predictor.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
an object of class \emph{overglm} in which the main results of the model fitted to the data are stored, i.e., a
list with components including
\tabular{ll}{
\code{coefficients} \tab a vector containing the parameter estimates,\cr
\tab \cr
\code{fitted.values}\tab a vector containing the estimates of \eqn{\mu_1,\ldots,\mu_n},\cr
\tab \cr
\code{start}        \tab a vector containing the starting values used,\cr
\tab \cr
\code{prior.weights}\tab a vector containing the case weights used,\cr
\tab \cr
\code{offset}       \tab a vector containing the offset used, \cr
\tab \cr
\code{terms}        \tab an object containing the terms objects,\cr
\tab \cr
\code{loglik}       \tab the value of the log-likelihood function avaliated at the parameter estimates,\cr
\tab \cr
\code{estfun}       \tab a vector containing the estimating functions evaluated at the parameter estimates\cr
                    \tab and the observed data,\cr
\tab \cr
\code{formula}      \tab the formula,\cr
\tab \cr
\code{levels}       \tab the levels of the categorical regressors,\cr
\tab \cr
\code{contrasts}    \tab an object containing the contrasts corresponding to levels,\cr
\tab \cr
\code{converged}    \tab a logical indicating successful convergence,\cr
\tab \cr
\code{model}        \tab the full model frame,\cr
\tab \cr
\code{y}            \tab the response count vector,\cr
\tab \cr
\code{family}       \tab an object containing the \link{family} object used,\cr
\tab \cr
\code{linear.predictors} \tab a vector containing the estimates of \eqn{g(\mu_1),\ldots,g(\mu_n)},\cr
\tab \cr
\code{R}            \tab a matrix with the Cholesky decomposition of the inverse of the variance-covariance\cr
                    \tab matrix of all parameters in the model,\cr
\tab \cr
\code{call}         \tab the original function call.\cr
}
}
\description{
Allows to fit regression models based on the negative binomial, beta-binomial, and random-clumped binomial
distributions, which are alternatives to the Poisson and binomial regression models under the presence of overdispersion.
}
\details{
The negative binomial distribution can be obtained as mixture of the Poisson and Gamma distributions. If
\eqn{Y | \lambda} ~ Poisson\eqn{(\lambda)}, where E\eqn{(Y | \lambda)=} Var\eqn{(Y | \lambda)=\lambda}, and
\eqn{\lambda} ~ Gamma\eqn{(\theta,\nu)}, in which E\eqn{(\lambda)=\theta} and Var\eqn{(\lambda)=\nu\theta^2}, then
\eqn{Y} is distributed according to the negative binomial distribution. As follows, some special cases are described:

(1) If \eqn{\theta=\mu} and \eqn{\nu=\phi} then \eqn{Y} ~ Negative Binomial I,
E\eqn{(Y)=\mu} and Var\eqn{(Y)=\mu(1 + \phi\mu)}.

(2) If \eqn{\theta=\mu} and \eqn{\nu=\phi/\mu} then \eqn{Y} ~ Negative Binomial II,
E\eqn{(Y)=\mu} and Var\eqn{(Y)=\mu(1 +\phi)}.

(3) If \eqn{\theta=\mu} and \eqn{\nu=\phi\mu^\tau} then \eqn{Y} ~ Negative Binomial,
E\eqn{(Y)=\mu} and Var\eqn{(Y)=\mu(1 +\phi\mu^{\tau+1})}.

Therefore, the regression models based on the negative binomial and
zero-truncated negative binomial distributions are alternatives under the presence of overdispersion
to those based on the Poisson and zero-truncated Poisson distributions, respectively.

The beta-binomial distribution can be obtained as mixture of the binomial and beta distributions. If
\eqn{mY | \pi} ~ Binomial\eqn{(m,\pi)}, where E\eqn{(Y | \pi)=\pi} and Var\eqn{(Y | \pi)=m^{-1}\pi(1-\pi)},
and \eqn{\pi} ~ Beta\eqn{(\mu,\phi)}, in which E\eqn{(\pi)=\mu} and Var\eqn{(\pi)=(\phi+1)^{-1}\mu(1-\mu)},
with \eqn{\phi>0}, then \eqn{mY} ~ Beta-Binomial\eqn{(m,\mu,\phi)}, so that E\eqn{(Y)=\mu} and
Var\eqn{(Y)=m^{-1}\mu(1-\mu)[1 + (\phi+1)^{-1}(m-1)]}. Therefore, the regression model based on the
beta-binomial distribution is an alternative under the presence of overdispersion to the binomial regression model.

The random-clumped binomial distribution can be obtained as mixture of the binomial and Bernoulli distributions. If
\eqn{mY | \pi} ~ Binomial\eqn{(m,\pi)}, where E\eqn{(Y | \pi)=\pi} and Var\eqn{(Y | \pi)=m^{-1}\pi(1-\pi)},
whereas \eqn{\pi=(1-\phi)\mu + \phi} with probability \eqn{\mu}, and \eqn{\pi=(1-\phi)\mu} with probability \eqn{1-\mu},
in which E\eqn{(\pi)=\mu} and Var\eqn{(\pi)=\phi^{2}\mu(1-\mu)}, with \eqn{\phi \in (0,1)}, then \eqn{mY} ~ Random-clumped
Binomial\eqn{(m,\mu,\phi)}, so that E\eqn{(Y)=\mu} and Var\eqn{(Y)=m^{-1}\mu(1-\mu)[1 + \phi^{2}(m-1)]}. Therefore,
the regression model based on the random-clumped binomial distribution is an alternative under the presence of
overdispersion to the binomial regression model.

In all cases, even in those where the response variable is described using a zero-truncated distribution, the fitted
model is aimed to describe the way in which \eqn{\mu} is dependent on some covariates. The parameter estimation is performed by using the
maximum likelihood method. The model parameters are estimated by maximizing the log-likelihood
function using the BFGS method available in the routine \link{optim}. The accuracy and speed of the BFGS
method are increased because of the call to the routine \link{optim} is performed using the analytical instead of the numerical
derivatives. The estimate of the variance-covariance matrix is obtained as being minus the inverse of the (analytical) hessian matrix
evaluated at the parameter estimates and the observed data.

A set of standard extractor functions for fitted model objects is available for objects of class  \emph{zeroinflation},
including methods to the generic functions such as \code{print}, \code{summary},	\code{model.matrix}, \code{estequa},
\code{coef}, \code{vcov}, \code{logLik}, \code{fitted}, \code{confint}, \code{AIC}, \code{BIC} and \code{predict}.
In addition, the model fitted to the	data may be assessed using functions such as \link{anova.overglm},
\link{residuals.overglm}, \link{dfbeta.overglm}, \link{cooks.distance.overglm}, \link{localInfluence.overglm},
\link{gvif.overglm} and \link{envelope.overglm}. The variable selection may be accomplished using the routine
\link{stepCriterion.overglm}.
}
\examples{
### Example 1: Ability of retinyl acetate to prevent mammary cancer in rats
data(mammary)
fit1 <- overglm(tumors ~ group, family="nb1(identity)", data=mammary)
summary(fit1)

### Example 2: Self diagnozed ear infections in swimmers
data(swimmers)
fit2 <- overglm(infections ~ frequency + location, family="nb1(log)", data=swimmers)
summary(fit2)

### Example 3: Urinary tract infections in HIV-infected men
data(uti)
fit3 <- overglm(episodes ~ cd4 + offset(log(time)), family="nb1(log)", data = uti)
summary(fit3)

### Example 4: Article production by graduate students in biochemistry PhD programs
bioChemists <- pscl::bioChemists
fit4 <- overglm(art ~ fem + kid5 + ment, family="nb1(log)", data = bioChemists)
summary(fit4)

### Example 5: Agents to stimulate cellular differentiation
data(cellular)
fit5 <- overglm(cbind(cells,200-cells) ~ tnf + ifn, family="bb(logit)", data=cellular)
summary(fit5)

### Example 6: Teratogenic effects of phenytoin and trichloropropene oxide
data(ossification)
model6 <- cbind(fetuses,litter-fetuses) ~ pht + tcpo
fit6 <- overglm(model6, family="rcb(cloglog)", data=ossification)
summary(fit6)

### Example 7: Germination of orobanche seeds
data(orobanche)
model7 <- cbind(germinated,seeds-germinated) ~ specie + extract
fit7 <- overglm(model7, family="rcb(cloglog)", data=orobanche)
summary(fit7)

}
\references{
Crowder, M. (1978) Beta-binomial anova for proportions, \emph{Journal of the Royal Statistical
Society Series C (Applied Statistics)} 27, 34-37.

Lawless, J.F. (1987) Negative binomial and mixed poisson regression, \emph{The Canadian Journal
of Statistics} 15, 209-225.

Morel, J.G. and Neerchal, N.K. (1997) Clustered binary logistic regression in teratology data
using a finite mixture distribution, \emph{Statistics in Medicine} 16, 2843-2853.

Morel, J.G. and Nagaraj, N.K. (2012) \emph{Overdispersion Models in SAS}. SAS Institute Inc.,
Cary, North Carolina, USA.
}
\seealso{
\link{zeroalt}, \link{zeroinf}
}
