% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{vdtest.lm}
\alias{vdtest.lm}
\title{Test for Varying Dispersion Parameter in Normal Linear Models}
\usage{
\method{vdtest}{lm}(model, varformula, verbose = TRUE, ...)
}
\arguments{
\item{model}{an object of the class lm which is obtained from the fit of a weighted or unweighted normal linear model.}

\item{varformula}{an (optional) \code{formula} expression of the form \code{~ predictors} describing only the potential explanatory variables for the dispersion. By default, the same explanatory variables are taken as in the model for the mean.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list which includes the three main attributes of the test for varying dispersion parameter: statistic ("statistic"), degrees of freedom ("df") and \emph{p}-value ("p.value").
}
\description{
Performs Rao's score test for varying dispersion parameter in weighted and unweighted normal linear models.
}
\details{
If the object \code{model} corresponds to an unweighted normal linear model then this test assess the assumption of constant variance, which
coincides with the (non-studentized) Breusch-Pagan test against heteroskedasticity.
}
\examples{
## Example 1
fit1 <- lm(mpg ~ log(hp) + log(wt), data=mtcars)
vdtest(fit1)

## Example 2
fit2 <- lm(Species ~ Biomass + pH, data=richness)
vdtest(fit2)

fit2a <- lm(Species ~ Biomass + pH, data=richness, subset=-c(1,3,18,20))
vdtest(fit2a)

## Example 3
whiteside <- MASS::whiteside
fit3 <- lm(Gas ~ Temp + Insul + Temp*Insul, data=whiteside)
vdtest(fit3)

fit3a <- lm(Gas ~ Temp + Insul + Temp*Insul, data=whiteside, subset=-c(8,9,36,46,55))
vdtest(fit3a)

}
\references{
Breusch T.S. and Pagan A.R. (1979) A simple test for heteroscedasticity and random coefficient variation. \emph{Econometrica} 47, 1287–1294.

Cook R.D. and Weisberg S. (1983) Diagnostics for heteroscedasticity in regression. \emph{Biometrika} 70, 1–10.
}
\seealso{
\link{vdtest.glm}
}
