% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm.R
\name{residuals.overglm}
\alias{residuals.overglm}
\title{Residuals for Negative Binomial and Beta-Binomial Regression Models}
\usage{
\method{residuals}{overglm}(
  object,
  ...,
  type = c("quantile", "standardized", "response"),
  plot.it = TRUE,
  identify
)
}
\arguments{
\item{object}{an object of the class overglm obtained from the fit of a negative binomial or beta-binomial model.}

\item{...}{further arguments passed to or from other methods.}

\item{type}{an (optional) character string giving the type of residuals which should be returned. The available options are: (1) the difference between the observed response and the fitted mean ("response"); (2) the standardized difference between the observed response and the fitted mean ("pearson"); (3) the randomized quantile residuals ("quantile"). By default, \code{type} is set to be "quantile".}

\item{plot.it}{an (optional) logical switch indicating if a plot of the residuals is required. By default, \code{plot} is set to be TRUE.}

\item{identify}{an (optional) integer value indicating the number of individuals to identify on the plot of residuals. This is only appropriate when \code{plot.it=TRUE}.}
}
\value{
A vector with the observed residuals type \code{type}.
}
\description{
Calculates residuals for a fitted negative binomial or beta-binomial model.
}
\examples{
## Example 1
fit1 <- overglm(cbind(fetuses,litter-fetuses) ~ pht + tcpo, family="bb(logit)", data=ossification)
residuals(fit1,type="quantile",col="red", pch=20,col.lab="blue",
          col.axis="blue",col.main="black",family="mono",cex=0.8)

## Example 2
fit2 <- overglm(infections ~ location + frequency, family="nb1(log)", data=swimmers)
residuals(fit2,type="quantile",col="red", pch=20,col.lab="blue",
          col.axis="blue",col.main="black",family="mono",cex=0.8)
}
\references{
Dunn P.K. and Smyth G.K. (1996) Randomized Quantile Residuals. \emph{Journal of Computational and Graphical Statistics}, 5, 236-244.
}
