% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cv_glmtlp.R
\name{plot.cv.glmtlp}
\alias{plot.cv.glmtlp}
\title{plot the cross-validation curve produced by cv.glmtlp}
\usage{
\method{plot}{cv.glmtlp}(x, vertical.line = TRUE, ...)
}
\arguments{
\item{x}{Fitted \code{"cv.glmtlp"} object}

\item{vertical.line}{Logical. Whether to include a vertical line indicating the 
position of the index which gives the smallest CV error.}

\item{\dots}{Other graphical parameters to plot}
}
\description{
Plots the cross-validation curve, and upper and lower standard deviation
  curves, as a function of the \code{lambda} or \code{kappa} values used.
}
\details{
A plot is produced, and a ggplot object is returned.
}
\examples{
X <- matrix(rnorm(100 * 20), 100, 20)
y <- rnorm(100)
cv.fit <- cv.glmtlp(X, y, family = "gaussian", penalty = "tlp")
plot(cv.fit)
plot(cv.fit, vertical.line = FALSE)
cv.fit2 <- cv.glmtlp(X, y, family = "gaussian", penalty = "l0")
plot(cv.fit2)
plot(cv.fit2, vertical.line = FALSE)

data("gau_data")
cv.fit <- cv.glmtlp(gau_data$X, gau_data$y, family = "gaussian", penalty = "tlp")
plot(cv.fit)

data("bin_data")
cv.fit <- cv.glmtlp(bin_data$X, bin_data$y, family = "binomial", penalty = "l1")
plot(cv.fit)

}
\references{
Shen, X., Pan, W., & Zhu, Y. (2012). 
  \emph{Likelihood-based selection and sharp parameter estimation. 
  Journal of the American Statistical Association, 107(497), 223-232.}
  \cr Yang, Y., & Zou, H. (2014). \emph{A coordinate majorization descent algorithm 
  for l1 penalized learning. Journal of Statistical Computation and 
  Simulation, 84(1), 84-95.}
  \cr Two R package Github: \emph{ncvreg} and \emph{glmnet}.
}
\author{
Chunlin Li, Yu Yang, Chong Wu 
  \cr Maintainer: Yu Yang \email{yang6367@umn.edu}
}
\keyword{models}
\keyword{plot}
