% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.glmnetr_240708.R
\name{plot.cv.glmnetr}
\alias{plot.cv.glmnetr}
\title{Plot cross-validation deviances, or model coefficients.}
\usage{
\method{plot}{cv.glmnetr}(
  x,
  gam = NULL,
  lambda.lo = NULL,
  plup = 0,
  title = NULL,
  coefs = FALSE,
  comment = TRUE,
  ...
)
}
\arguments{
\item{x}{a cv.glmnetr()  output object.}

\item{gam}{a specific level of gamma for plotting.  By default gamma.min will be used.}

\item{lambda.lo}{a lower limit of lambda when plotting.}

\item{plup}{an indicator to plot the upper 95 percent two-sided confidence limits.}

\item{title}{a title for the plot.}

\item{coefs}{default of FALSE plots deviances, option of TRUE plots coefficients.}

\item{comment}{default of TRUE to write to console information on lam and gam selected for output.
FALSE will suppress this write to console.}

\item{...}{Additional arguments passed to the plot function.}
}
\value{
This program returns a plot to the graphics window, and may provide 
some numerical information to the R Console.  If gam is not specified, then 
then the gamma.min from the deviance minimizing (lambda.min, gamma.min) pair 
will be used, and the corresponding lambda.min will be indicated by a vertical
line, and the lambda minimizing deviance under the restricted set of models 
where gamma=0 will be indicated by a second vertical line.
}
\description{
By default, with coefs=FALSE, plots the average deviances as function of lam (lambda) and gam (gamma), and also 
indicates the gam and lam which minimize deviance based upon a cv.glmnetr() output object.
Optionally, with coefs=TRUE, plots the relaxed lasso coefficients.
}
\examples{
# set seed for random numbers, optionally, to get reproducible results
set.seed(82545037)
sim.data=glmnetr.simdata(nrows=100, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$y_ 
event=sim.data$event
# for this example we use a small number for folds_n to shorten run time 
cv_glmnetr_fit = cv.glmnetr(xs, NULL, y_, NULL, family="gaussian", folds_n=3, limit=2) 
plot(cv_glmnetr_fit)
plot(cv_glmnetr_fit, coefs=1)

}
\seealso{
\code{\link{plot.glmnetr}} , \code{\link{plot.nested.glmnetr}} , \code{\link{cv.glmnetr}}
}
