% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.stepreg_240322.R
\name{summary.cv.stepreg}
\alias{summary.cv.stepreg}
\title{Summarize results from a cv.stepreg() output object.}
\usage{
\method{summary}{cv.stepreg}(object, ...)
}
\arguments{
\item{object}{A cv.stepreg() output object}

\item{...}{Additional arguments passed to the summary function.}
}
\value{
Summary of a stepreg() (stepwise regression) output object.
}
\description{
Summarize results from a cv.stepreg() output object.
}
\examples{
set.seed(955702213)
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=c(0,1,1))
# this gives a more interesting case but takes longer to run
xs=sim.data$xs           
# this will work numerically as an example 
xs=sim.data$xs[,c(2,3,50:55)] 
dim(xs)
y_=sim.data$yt 
event=sim.data$event
# for this example we use small numbers for steps_n and folds_n to shorten run time 
cv.stepreg.fit = cv.stepreg(xs, NULL, y_, event, steps_n=10, folds_n=3, track=0)
summary(cv.stepreg.fit)


}
\seealso{
\code{\link{predict.cv.stepreg}}  , \code{\link{cv.stepreg}} , \code{\link{nested.glmnetr}}
}
