% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.nested.glmnetr_240322.R
\name{glmnetr.compcv}
\alias{glmnetr.compcv}
\title{Compare cross validation fits from a nested.glmnetr output.}
\usage{
glmnetr.compcv(object, digits = 4, type = "devrat", pow = 1)
}
\arguments{
\item{object}{A nested.glmnetr output object.}

\item{digits}{digits for printing of z-scores, p-values, etc. with default of 4}

\item{type}{determines what type of nested cross validation performance measures are 
compared.  Possible values are "devrat" to compare the deviance ratios, i.e. the 
fractional reduction in deviance relative to the null model deviance, 
"agree" to compare agreement, "lincal" to compare the linear calibration 
slope coefficients, "intcal" to compare the linear calibration intercept 
coefficients, from the nested cross validation.}

\item{pow}{the power to which the average of correlations is to be raised.  Only 
applies to the "gaussian" model.  Default is 2 to yield R-square but can be on to 
show correlations.  pow is ignored for the family of "cox" and "binomial".}
}
\value{
A printout to the R console.
}
\description{
Compare cross-validation model fits in terms of average concordance from the 
nested cross validaiton fits.
}
\examples{
\donttest{
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$yt
event=sim.data$event
# for this example we use a small number for folds_n to shorten run time 
fit3 = nested.glmnetr(xs, NULL, y_, event, family="cox", folds_n=3) 
glmnetr.compcv(fit3)
}

}
\seealso{
\code{\link{summary.nested.glmnetr}} , \code{\link{nested.glmnetr}}
}
