% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extrafunctions.R
\name{match_rows}
\alias{match_rows}
\title{Generate matrix mapping between data frames}
\usage{
match_rows(x, target, by)
}
\arguments{
\item{x}{data.frame}

\item{target}{data.frame to map to}

\item{by}{vector of strings naming columns in `x` and `target`}
}
\value{
A matrix with nrow(x) rows and nrow(target) columns
}
\description{
For a data frames `x` and `target`, the function will return a matrix mapping the rows of
`x` to those of `target`.
}
\details{
`x` is a data frame with n rows and `target` a data frame with m rows. This function will
return a n times m matrix that maps the rows of `x` to those of `target` based on the values
in the columns specified by the argument `by`
}
\examples{
df <- nelder(~(cl(10)*t(5)) > ind(10))
df_unique <- df[!duplicated(df[,c('cl','t')]),]
match_rows(df,df_unique,c('cl','t'))
}
