% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcn.R
\name{getS}
\alias{getS}
\title{Estimate standardized Laplacian matrix}
\usage{
getS(x, sparse = T)
}
\arguments{
\item{x}{data}

\item{sparse}{estimate a sparse network or not, default to be T, but may be slow}
}
\value{
standardized laplacian matrix
}
\description{
Estimate standardized Laplacian matrix given data using gene co-expression network method
}
\examples{
xx <- matrix(rnorm(12), 3, 4)
ss <- getS(xx, FALSE)
}
\references{
Ucar D, Neuhaus I, Ross-MacDonald P, Tilford C, Parthasarathy S, et al. (2007) Construction of a reference gene association network from multiple profiling data: application to data analysis. Bioinformatics 23: 2716-2724.

Meinshausen, N., & B{"u}hlmann, P. (2006). High-dimensional graphs and variable selection with the lasso. The annals of statistics, 1436-1462.
}
