% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictLVs.gllvm.R
\name{predictLVs.gllvm}
\alias{predictLVs.gllvm}
\alias{predictLVs}
\title{Predict latent variables for gllvm Fits}
\usage{
\method{predictLVs}{gllvm}(object, newX = if (is.null(object$X)) NULL
  else object$X, newY = object$y, ...)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{newX}{A new data frame of environmental variables. If omitted, the original matrix of environmental variables is used.}

\item{newY}{A new response data. Defaults to the dataset used for original model fit.}

\item{...}{not used.}
}
\value{
A matrix containing requested predictor types.
}
\description{
Obtains predictions for latent variables from a fitted generalized linear latent variable model object. Currently works only for the variational approximation method.
}
\details{
Obtains predictions for latent variables from a fitted generalized linear latent variable model object.
}
\examples{
 \donttest{
# Load a dataset from the mvabund package
data(antTraits)
y <- as.matrix(antTraits$abund)
X <- scale(antTraits$env[, 1:3])
# Fit gllvm model
fit <- gllvm(y = y, X, family = poisson())
# fitted values
predLVs <- predictLVs.gllvm(fit, type = "response")
}
}
\author{
David Warton, Jenni Niku <jenni.m.e.niku@jyu.fi>
}
