% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info_files.R
\name{get_info}
\alias{get_info}
\title{Get the first and last modification time for a specific file, based on git2r::blame().}
\usage{
get_info(path, repo = ".")
}
\arguments{
\item{path}{path to the file}

\item{repo}{repo of the git project}
}
\value{
A list with information of the selected file:
\itemize{
\item file: file name
\item in_repository: Logical. Whether the file has already been commit once in the
git repository
\item first_modif: time of first modification. Commit time if in the git repository,
system date of creation otherwise.
\item last_modif: time of last modification. Commit time if in the git repository,
system date of last modification otherwise.
}
}
\description{
Get the first and last modification time for a specific file, based on git2r::blame().
}
\examples{
repo <- fake_repo()
get_info(list.files(repo)[1], repo = repo)
}
