% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit.r
\docType{methods}
\name{summary,git_commit-method}
\alias{summary,git_commit-method}
\alias{summary,git_commit-methods}
\title{Summary of commit}
\usage{
\S4method{summary}{git_commit}(object, ...)
}
\arguments{
\item{object}{The commit \code{object}}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
None (invisible 'NULL').
}
\description{
Summary of commit
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Config user
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Summary of commit in repository
summary(commits(repo)[[1]])
}
}
\keyword{methods}

