% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_units.R
\name{gisco_get_units}
\alias{gisco_get_units}
\title{Get geospatial units data from GISCO API}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/}{
GISCO API}
}
\usage{
gisco_get_units(
  id_giscoR = "nuts",
  unit = "ES4",
  mode = "sf",
  year = "2016",
  epsg = "4326",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = "20",
  spatialtype = "RG"
)
}
\arguments{
\item{id_giscoR}{Select the \code{unit} type to be downloaded.
Accepted values are \code{'nuts','countries'} or \code{'urban_audit'}.}

\item{unit}{Unit ID to be downloaded. See Details.}

\item{mode}{Controls the output of the function. Possible values
are \code{"sf"} or \code{"df"}. See Value and Details.}

\item{year, epsg, cache, update_cache, cache_dir, verbose, resolution}{See
\link{gisco_get}.}

\item{spatialtype}{Type of geometry to be returned: \code{"RG"}
for \code{POLYGON} and \code{"LB"} for \code{POINT}.}
}
\value{
A \code{sf} object on \code{mode = "sf"} or a dataframe on
\code{mode = "df"}.
}
\description{
Download individual shapefiles of units. Unlike
\link{gisco_get_countries}, \link{gisco_get_nuts} or
\link{gisco_get_urban_audit}, that downloads a full dataset
and applies filters, \code{gisco_get_units} downloads a single shapefiles
for each unit.
}
\details{
The function can return a dataframe on \code{mode = "df"}
or a \code{sf} object on \code{mode = "sf"}

In order to see the available \code{unit} ids with the required
combination of \code{what,year}, first run the function on \code{"df"}
mode. Once that you get the data frame you can select the required ids
on the \code{unit} parameter.

On \code{mode = "df"} the only relevant parameters are \code{what, year}.
}
\note{
\code{countries} file would be renamed on your \code{cache_dir}
to avoid naming conflicts with \code{nuts} datasets.
}
\examples{
\dontrun{
library(sf)

if (gisco_check_access()) {
  cities <- gisco_get_units(id_giscoR = "urban_audit",
                            mode = "df",
                            year = "2020")
  VAL <- cities[grep("Valencia", cities$URAU_NAME),]
  # Order from big to small
  VAL <- VAL[order(as.double(VAL$AREA_SQM), decreasing =  TRUE), ]

  VAL.sf <- gisco_get_units(id_giscoR = "urban_audit",
                            year = "2020",
                            unit = VAL$URAU_CODE)
  # Provincia
  Provincia <-
    gisco_get_units(id_giscoR = "nuts",
                    unit = c("ES523"),
                    resolution = "01")

  # Surrounding area
  NUTS1 <-
    gisco_get_units(id_giscoR = "nuts",
                    unit = c("ES5"),
                    resolution = "01")

  # Plot
  plot(
    st_geometry(Provincia),
    col = "gray1",
    border = "grey50",
    lwd = 3
  )
  plot(st_geometry(NUTS1),
       border = "grey50",
       lwd = 3,
       add = TRUE)
  plot(
    st_geometry(VAL.sf),
    col = c("deeppink4", "brown2", "khaki1"),
    add = TRUE
  )
  box()
  title(
    "Urban Audit - Valencia (ES)",
    sub = gisco_attributions("es"),
    line = 1,
    cex.sub = 0.7
  )
}
}
}
\seealso{
\link{gisco_get}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
