% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_gamma_function.R
\name{calculate_gamma_function}
\alias{calculate_gamma_function}
\title{Calculate Gamma function}
\usage{
calculate_gamma_function(perm, lambda)
}
\arguments{
\item{perm}{An object of a \code{gips_perm} class.
It can also be of a \code{gips} class, but
it will be interpreted as the underlying \code{gips_perm}.}

\item{lambda}{A positive real number.}
}
\value{
Returns the value of the Gamma function of the colored cone
(for definition of colored cone, see the \strong{Basic definitions} section
in \code{vignette("Theory", package = "gips")} or in its
\href{https://przechoj.github.io/gips/articles/Theory.html}{pkgdown page}).
}
\description{
It calculates the value of the integral defined in
\href{https://arxiv.org/abs/2004.03503}{Definition 11 from references}.
It implements
\href{https://arxiv.org/abs/2004.03503}{Theorem 8 from references}
and uses the
\href{https://arxiv.org/abs/2004.03503}{formula (19) from references}.
}
\examples{
id_perm <- gips_perm("()", 2)
calculate_gamma_function(id_perm, 0.5001) # 10.7...
calculate_gamma_function(id_perm, 0.50000001) # 19.9...
calculate_gamma_function(id_perm, 0.500000000001) # 29.1...

oldw <- getOption("warn")
options(warn = -1)
calculate_gamma_function(id_perm, 0.5) # Inf
# Integral diverges; returns Inf and warning
options(warn = oldw)

}
\references{
Piotr Graczyk, Hideyuki Ishi, Bartosz Kołodziejek, Hélène Massam.
"Model selection in the space of Gaussian models invariant by symmetry."
The Annals of Statistics, 50(3) 1747-1774 June 2022.
\href{https://arxiv.org/abs/2004.03503}{arXiv link};
\doi{10.1214/22-AOS2174}
}
\seealso{
\itemize{
\item \code{\link[=get_structure_constants]{get_structure_constants()}} - The function useful inside
the \code{calculate_gamma_function()}.
\item \code{\link[=log_posteriori_of_gips]{log_posteriori_of_gips()}} - The function that uses
the values of the gamma function.
\item \code{vignette("Theory", package = "gips")} or its
\href{https://przechoj.github.io/gips/articles/Theory.html}{pkgdown page} -
A place to learn more about
the math behind the \code{gips} package.
}
}
