% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rasterizeGimms.R
\name{rasterizeGimms}
\alias{rasterizeGimms}
\title{Rasterize GIMMS NDVI3g binary data}
\usage{
rasterizeGimms(x, header = NULL, water2na = TRUE, nodata2na = TRUE,
  scaling = TRUE, remove_header = FALSE, filename = "", ...)
}
\arguments{
\item{x}{Character. Vector of local filepaths.}

\item{header}{Character. Companion header files corresponding to the binary data
in 'x'. If missing, the standard header file for GIMMS NDVI3g binary data as
created by \code{\link{createHeader}} will be used.}

\item{water2na}{Logical. If \code{TRUE} (default), pixels with 'mask-water'
value (-10000) will be discarded. See also
\url{http://ecocast.arc.nasa.gov/data/pub/gimms/3g.v0/00READMEgeo.txt}.}

\item{nodata2na}{Logical. If \code{TRUE} (default), pixels with 'mask-nodata'
value (-5000) will be discarded.}

\item{scaling}{Logical. If \code{TRUE} (default), initial values will be
scaled by a factor of 1/10000.}

\item{remove_header}{Logical. If \code{FALSE} (default), the header file
specified in 'header' or, if not specified, created internally via
\code{\link{createHeader}} will be removed after all operations have finished.}

\item{filename}{Character. Optional output filename, see
\code{\link{writeRaster}}.}

\item{...}{Further arguments passed on to \code{\link{writeRaster}}.}
}
\value{
If 'x' is a single filename, an object of class 'RasterLayer'; <br>
if 'x' is a vector of filenames, an object of class 'RasterStack'.
}
\description{
Import GIMMS NDVI3g binary data into R as 'Raster*' objects based on a
companion header file.
}
\examples{
\dontrun{
## Destination folder for data download
gimms_dir <- paste0(getwd(), "/data")

## Download GIMMS NDVI3g binary data from 2000-2005
gimms_files <- downloadGimms(x = 2000, y = 2005, dsn = gimms_dir)

## Rasterize downloaded GIMMS files from January and February 2000
gimms_raster <- rasterizeGimms(x = gimms_files[1:4], remove_header = TRUE)

plot(gimms_raster)
}
}
\author{
Florian Detsch
}
\seealso{
\code{\link{createHeader}}, \code{\link{raster}}, \code{\link{writeRaster}}.
}

