% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/layer_guess.R
\name{layer_guess}
\alias{layer_guess}
\title{Guess the right type of layer based on current properties.}
\usage{
layer_guess(vis, ...)
}
\arguments{
\item{vis}{The visualisation to add the new layer to.}

\item{...}{Other arguments passed on individual layers.}
}
\description{
\code{layer_guess} provides the magic behind the default behaviour of
\code{\link{ggvis}}.
}
\section{Defaults}{


\itemize{
  \item Continuous x, \code{\link{layer_histograms}}
  \item Categorical x, \code{\link{layer_bars}}
  \item Continuous x and y, \code{\link{layer_points}}
}
}
\examples{
# A scatterplot:
mtcars \%>\% ggvis(~mpg, ~wt)
mtcars \%>\% ggvis(~mpg, ~wt) \%>\% layer_guess()

# A histogram:
mtcars \%>\% ggvis(~mpg)
mtcars \%>\% ggvis(~mpg) \%>\% layer_guess()
}

