% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales-tern.R
\name{scale_X_continuous}
\alias{scale_X_continuous}
\alias{scale_T_continuous}
\alias{scale_L_continuous}
\alias{scale_R_continuous}
\title{Ternary Position Scales}
\usage{
scale_T_continuous(name = waiver(), limits = NULL, breaks = waiver(),
  minor_breaks = waiver(), labels = waiver(), ...)

scale_L_continuous(name = waiver(), limits = NULL, breaks = waiver(),
  minor_breaks = waiver(), labels = waiver(), ...)

scale_R_continuous(name = waiver(), limits = NULL, breaks = waiver(),
  minor_breaks = waiver(), labels = waiver(), ...)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[=coord_cartesian]{coord_cartesian()}}).
}}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:trans_new]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:extended_breaks]{scales::extended_breaks()}})
}}

\item{minor_breaks}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks.
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}

\item{...}{not used}
}
\description{
Define the ternary continuous position scales (T, L & R).
}
\author{
Nicholas Hamilton
}
