% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggscatterstats.R
\name{grouped_ggscatterstats}
\alias{grouped_ggscatterstats}
\title{Scatterplot with marginal distributions for all levels of a grouping
variable}
\usage{
grouped_ggscatterstats(
  data,
  x,
  y,
  grouping.var,
  label.var = NULL,
  label.expression = NULL,
  output = "plot",
  plotgrid.args = list(),
  annotation.args = list(),
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted.}

\item{x}{The column in \code{data} containing the explanatory variable to be
plotted on the \code{x}-axis. Can be entered either as a character string (e.g.,
\code{"x"}) or as a bare expression (e.g, \code{x}).}

\item{y}{The column in \code{data} containing the response (outcome) variable to
be plotted on the \code{y}-axis. Can be entered either as a character string
(e.g., \code{"y"}) or as a bare expression (e.g, \code{y}).}

\item{grouping.var}{A single grouping variable (can be entered either as a
bare name \code{x} or as a string \code{"x"}).}

\item{label.var}{Variable to use for points labels. Can be entered either as
a bare expression (e.g, \code{var1}) or as a string (e.g., \code{"var1"}).}

\item{label.expression}{An expression evaluating to a logical vector that
determines the subset of data points to label. This argument can be entered
either as a bare expression (e.g., \code{y < 4 & z < 20}) or as a string (e.g.,
\code{"y < 4 & z < 20"}).}

\item{output}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results. If
you have set \code{results.subtitle = FALSE}, then this will return a \code{NULL}.
Setting this to \code{"caption"} will return the expression containing details
about Bayes Factor analysis, but valid only when \code{type = "parametric"} and
\code{bf.message = TRUE}, otherwise this will return a \code{NULL}.}

\item{plotgrid.args}{A \code{list} of additional arguments passed to
\code{patchwork::wrap_plots}, except for \code{guides} argument which is already
separately specified here.}

\item{annotation.args}{A \code{list} of additional arguments passed to
\code{patchwork::plot_annotation}.}

\item{...}{
  Arguments passed on to \code{\link[=ggscatterstats]{ggscatterstats}}
  \describe{
    \item{\code{point.label.args}}{A list of additional aesthetic arguments to be passed
to \code{ggrepel::geom_label_repel} geom used to display the labels.}
    \item{\code{smooth.line.args}}{A list of additional aesthetic arguments to be passed
to \code{ggplot2::geom_smooth} geom used to display the regression line.}
    \item{\code{point.args}}{A list of additional aesthetic arguments to be passed
to \code{ggplot2::geom_point} geom used to display the raw data points.}
    \item{\code{marginal}}{Decides whether \code{ggExtra::ggMarginal()} plots will be
displayed; the default is \code{TRUE}.}
    \item{\code{point.width.jitter}}{Degree of jitter in \code{x} and \code{y}
direction, respectively. Defaults to \code{0} (0\%) of the resolution of the
data. Note that the jitter should not be specified in the \code{point.args}
because this information will be passed to two different \code{geom}s: one
displaying the \strong{points} and the other displaying the *\strong{labels} for
these points.}
    \item{\code{point.height.jitter}}{Degree of jitter in \code{x} and \code{y}
direction, respectively. Defaults to \code{0} (0\%) of the resolution of the
data. Note that the jitter should not be specified in the \code{point.args}
because this information will be passed to two different \code{geom}s: one
displaying the \strong{points} and the other displaying the *\strong{labels} for
these points.}
    \item{\code{marginal.type}}{Type of marginal distribution to be plotted on the axes
(\code{"histogram"}, \code{"boxplot"}, \code{"density"}, \code{"violin"}, \code{"densigram"}).}
    \item{\code{marginal.size}}{Integer describing the relative size of the marginal
plots compared to the main plot. A size of \code{5} means that the main plot is
5x wider and 5x taller than the marginal plots.}
    \item{\code{xfill}}{Character describing color fill for \code{x} and \code{y} axes
marginal distributions (default: \code{"#009E73"} (for \code{x}) and \code{"#D55E00"} (for
\code{y})). Note that the defaults are colorblind-friendly.}
    \item{\code{yfill}}{Character describing color fill for \code{x} and \code{y} axes
marginal distributions (default: \code{"#009E73"} (for \code{x}) and \code{"#D55E00"} (for
\code{y})). Note that the defaults are colorblind-friendly.}
    \item{\code{type}}{A character specifying the type of statistical approach.
Four possible options:

\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

Corresponding abbreviations are also accepted: \code{"p"} (for parametric),
\code{"np"} (for nonparametric), \code{"r"} (for robust), or \code{"bf"} (for Bayesian).}
    \item{\code{conf.level}}{Scalar between \code{0} and \code{1}. If unspecified, the defaults
return \verb{95\%} confidence/credible intervals (\code{0.95}).}
    \item{\code{bf.prior}}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors and posterior estimates.}
    \item{\code{tr}}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}
    \item{\code{k}}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}
    \item{\code{ggtheme}}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}
    \item{\code{ggstatsplot.layer}}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}
    \item{\code{bf.message}}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}
    \item{\code{results.subtitle}}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}
    \item{\code{xlab}}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}
    \item{\code{ylab}}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}
    \item{\code{subtitle}}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}
    \item{\code{caption}}{The text for the plot caption.}
    \item{\code{ggplot.component}}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_}
variants of all primary functions. Default is \code{NULL}. The argument should
be entered as a \code{ggplot2} function or a list of \code{ggplot2} functions.}
  }}
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("maturing")}

Grouped scatterplots from \code{ggplot2} combined with marginal distribution plots
with statistical details added as a subtitle.
}
\examples{
# to ensure reproducibility
set.seed(123)
library(ggstatsplot)

# basic function call
grouped_ggscatterstats(
  data = dplyr::filter(movies_long, genre == "Comedy" | genre == "Drama"),
  x = length,
  y = rating,
  type = "robust",
  grouping.var = genre
)

# using labeling
# (also show how to modify basic plot from within function call)
grouped_ggscatterstats(
  data = dplyr::filter(ggplot2::mpg, cyl != 5),
  x = displ,
  y = hwy,
  grouping.var = cyl,
  type = "robust",
  label.var = manufacturer,
  label.expression = hwy > 25 & displ > 2.5,
  ggplot.component = ggplot2::scale_y_continuous(sec.axis = ggplot2::dup_axis())
)

# labeling without expression

grouped_ggscatterstats(
  data = dplyr::filter(
    .data = movies_long,
    rating == 7,
    genre \%in\% c("Drama", "Comedy")
  ),
  x = budget,
  y = length,
  grouping.var = genre,
  bf.message = FALSE,
  label.var = "title",
  marginal = FALSE,
  annotation.args = list(caption = "All movies have IMDB rating greater than 7")
)
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggscatterstats.html}
}
\seealso{
\code{\link{ggscatterstats}}, \code{\link{ggcorrmat}},
\code{\link{grouped_ggcorrmat}}
}
