% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_effsize_ci.R
\name{t1way_ci}
\alias{t1way_ci}
\title{#' @title A heteroscedastic one-way ANOVA for trimmed means with confidence
interval for effect size.}
\usage{
t1way_ci(data, x, y, tr = 0.1, nboot = 100, conf.level = 0.95,
  conf.type = "norm", ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}

\item{nboot}{Number of bootstrap samples for computing effect size (Default:
\code{100}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{...}{Arguments passed on to \code{boot::boot}
\describe{
  \item{data}{
    The data as a vector, matrix or data frame.  If it is a matrix or
    data frame then each row is considered as one multivariate
    observation.
  }
  \item{statistic}{
    A function which when applied to data returns a vector containing
    the statistic(s) of interest.  When \code{sim = "parametric"}, the
    first argument to \code{statistic} must be the data.  For each
    replicate a simulated dataset returned by \code{ran.gen} will be
    passed.  In all other cases \code{statistic} must take at least two
    arguments.  The first argument passed will always be the original
    data.  The second will be a vector of indices, frequencies or weights
    which define the bootstrap sample.  Further, if predictions are
    required, then a third argument is required which would be a vector
    of the random indices used to generate the bootstrap predictions.
    Any further arguments can be passed to \code{statistic} through the
    \code{\dots} argument.
  }
  \item{R}{
    The number of bootstrap replicates.  Usually this will be a single
    positive integer.  For importance resampling, some resamples may use
    one set of weights and others use a different set of weights.  In
    this case \code{R} would be a vector of integers where each
    component gives the number of resamples from each of the rows of
    weights.
  }
  \item{sim}{
    A character string indicating the type of simulation required.
    Possible values are \code{"ordinary"} (the default),
    \code{"parametric"}, \code{"balanced"}, \code{"permutation"}, or
    \code{"antithetic"}.  Importance resampling is specified by
    including importance weights; the type of importance resampling must
    still be specified but may only be \code{"ordinary"} or
    \code{"balanced"} in this case.
  }
  \item{stype}{
    A character string indicating what the second argument of \code{statistic}
    represents.  Possible values of stype are \code{"i"} (indices - the
    default), \code{"f"} (frequencies), or \code{"w"} (weights).  Not
    used for \code{sim = "parametric"}.
  }
  \item{strata}{
    An integer vector or factor specifying the strata for multi-sample
    problems.  This may be specified for any simulation, but is ignored
    when \code{sim = "parametric"}.  When \code{strata} is
    supplied for a nonparametric bootstrap, the simulations are done
    within the specified strata.
  }
  \item{L}{
    Vector of influence values evaluated at the observations.  This is
    used only when \code{sim} is \code{"antithetic"}.  If not supplied,
    they are calculated through a call to \code{empinf}.  This will use
    the infinitesimal jackknife provided that \code{stype} is
    \code{"w"}, otherwise the usual jackknife is used.
  }
  \item{m}{
    The number of predictions which are to be made at each bootstrap
    replicate.  This is most useful for (generalized) linear models.
    This can only be used when \code{sim} is \code{"ordinary"}.
    \code{m} will usually be a single integer but, if there are strata,
    it may be a vector with length equal to the number of strata,
    specifying how many of the errors for prediction should come from
    each strata.  The actual predictions should be returned as the final
    part of the output of \code{statistic}, which should also take an
    argument giving the vector of indices of the errors to be used for
    the predictions.
  }
  \item{weights}{
    Vector or matrix of importance weights.  If a vector then it should
    have as many elements as there are observations in \code{data}.
    When simulation from more than one set of weights is required,
    \code{weights} should be a matrix where each row of the matrix is
    one set of importance weights.  If \code{weights} is a matrix then
    \code{R} must be a vector of length \code{nrow(weights)}.  This
    parameter is ignored if \code{sim} is not \code{"ordinary"} or
    \code{"balanced"}.
  }
  \item{ran.gen}{
    This function is used only when \code{sim = "parametric"}
    when it describes how random values are to be generated.  It should
    be a function of two arguments.  The first argument should be the
    observed data and the second argument consists of any other
    information needed (e.g. parameter estimates).  The second argument
    may be a list, allowing any number of items to be passed to
    \code{ran.gen}.  The returned value should be a simulated data set
    of the same form as the observed data which will be passed to
    \code{statistic} to get a bootstrap replicate.  It is important that the
    returned value be of the same shape and type as the original
    dataset.  If \code{ran.gen} is not specified, the default is a
    function which returns the original \code{data} in which case all
    simulation should be included as part of \code{statistic}.  Use of
    \code{sim = "parametric"} with a suitable \code{ran.gen} allows the
    user to implement any types of nonparametric resampling which are
    not supported directly.
  }
  \item{mle}{
    The second argument to be passed to \code{ran.gen}.  Typically these
    will be maximum likelihood estimates of the parameters.  For
    efficiency \code{mle} is often a list containing all of the objects
    needed by \code{ran.gen} which can be calculated using the original
    data set only.
  }
  \item{simple}{logical, only allowed to be \code{TRUE} for
    \code{sim = "ordinary", stype = "i", n = 0} (otherwise ignored with a
    warning).  By default a \code{n} by \code{R} index array is created:
    this can be large and if \code{simple = TRUE} this is avoided by
    sampling separately for each replication, which is slower but uses
    less memory.
  }
  \item{parallel}{
    The type of parallel operation to be used (if any).  If missing, the
    default is taken from the option \code{"boot.parallel"} (and if that
    is not set, \code{"no"}).
  }
  \item{ncpus}{
    integer: number of processes to be used in parallel operation:
    typically one would chose this to the number of available CPUs.
  }
  \item{cl}{
    An optional \pkg{parallel} or \pkg{snow} cluster for use if
    \code{parallel = "snow"}.  If not supplied, a cluster on the
    local machine is created for the duration of the \code{boot} call.
  }
}}
}
\description{
Custom function to get confidence intervals for effect size
measure for robust ANOVA.
}
\examples{
\dontrun{
set.seed(123)
ggstatsplot:::t1way_ci(
  data = dplyr::filter(ggplot2::msleep, vore != "insecti"),
  x = vore,
  y = brainwt,
  tr = 0.05,
  nboot = 50,
  conf.level = 0.99,
  conf.type = "perc"
)
}

}
\keyword{internal}
