% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_messages.R
\name{normality_message}
\alias{normality_message}
\title{Display normality test result as a message.}
\usage{
normality_message(x, lab = NULL, k = 2, output = "message", ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{lab}{A character describing label for the variable. If \code{NULL}, a
generic \code{"x"} label will be used.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{output}{What output is desired: \code{"message"} (default) or \code{"stats"} (or
\code{"tidy"}) objects.}

\item{...}{Additional arguments (ignored).}
}
\value{
A list with class \code{"htest"} containing the following components:
  \item{statistic}{the value of the Shapiro-Wilk statistic.}
  \item{p.value}{an approximate p-value for the test.  This is
    said in Royston (1995) to be adequate for \code{p.value < 0.1}.}
  \item{method}{the character string \code{"Shapiro-Wilk normality test"}.}
  \item{data.name}{a character string giving the name(s) of the data.}
}
\description{
A note to the user about the validity of assumptions for the
default linear model.
}
\examples{

# message
normality_message(
  x = anscombe$x1,
  lab = "x1",
  k = 3
)

# statistical test object
ggstatsplot::normality_message(
  x = anscombe$x2,
  output = "tidy"
)
}
\seealso{
\code{\link{ggbetweenstats}}

Other helper_messages: \code{\link{bartlett_message}},
  \code{\link{effsize_ci_message}},
  \code{\link{ggcorrmat_matrix_message}},
  \code{\link{grouped_message}}, \code{\link{pairwise_p}},
  \code{\link{palette_message}}
}
\author{
Indrajeet Patil
}
\concept{helper_messages}
