% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohenG_ci.R
\name{cohenG_ci}
\alias{cohenG_ci}
\title{Confidence intervals for Cohen's \emph{g} effect size.}
\usage{
cohenG_ci(x, nboot = 100, conf.level = 0.95, conf.type = "norm", ...)
}
\arguments{
\item{x}{A two-way contingency table. It must be square. 
It can have two or
more levels for each dimension.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}
}
\description{
Confidence intervals for Cohen's \emph{g} effect size.
}
\examples{
\dontrun{
library(rcompanion)
ggstatsplot:::cohenG_ci(AndersonRainGarden)
}

}
\author{
Indrajeet Patil
}
\keyword{internal}
