% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csv_to_ggplot.R
\name{csv_to_ggplot}
\alias{csv_to_ggplot}
\title{Convert CSV files (from ggsem Shiny app) to ggplot output}
\usage{
csv_to_ggplot(
  points_data = NULL,
  lines_data = NULL,
  annotations_data = NULL,
  loops_data = NULL,
  element_order = c("lines", "points", "self_loops", "annotations"),
  zoom_level = 1.2,
  horizontal_position = 0,
  vertical_position = 0,
  n = 100
)
}
\arguments{
\item{points_data}{An object that stores the CSV file containing information about points from the ggsem shiny app. The default is NULL.}

\item{lines_data}{An object that stores the CSV file containing information about lines from the ggsem shiny app. The default is NULL.}

\item{annotations_data}{An object that stores the CSV file containing information about text annotations from the ggsem shiny app. The default is NULL.}

\item{loops_data}{An object that stores the CSV file containing information about self-loop arrows from the ggsem shiny app. The default is NULL.}

\item{element_order}{Order of the graphical elements on display. This is the order in which the graphical elements are added. So if it is written later, then it gets added later (more front),
such as: c("lines", "points", "self_loops", "annotations"), which sets annotations to be added last (and hence most front).}

\item{zoom_level}{A numeric value to control the zoom level of the plot. Default is 1.2.}

\item{horizontal_position}{A numeric value for adjusting the horizontal position of the plot. Default is 0.}

\item{vertical_position}{A numeric value for adjusting the vertical position of the plot. Default is 0.}

\item{n}{Number of points to be used for interpolation (for gradient lines or curved lines). Default is 100.}
}
\value{
A ggplot object is returned as the function's output.
}
\description{
This function converts the four CSV files from the ggsem Shiny app into a ggplot output object.
The ggplot output can then be modified using standard ggplot2 functions, such as ggtitle() and annotate().
}
\examples{
library(ggplot2)

# CSV files from ggsem app
points_data <- data.frame(
x = 5, y = 5, shape = 'square', color = '#D0C5ED', size = 50,
border_color = '#9646D4', border_width = 2, alpha = 1,
locked = FALSE, lavaan = FALSE
)

lines_data <- data.frame(
x_start = 2, y_start = -2, x_end = 8, y_end = -2, ctrl_x = NA, ctrl_y = NA,
type = 'Straight Line', color = '#000000', end_color = NA, color_type = 'Single',
gradient_position = NA, width = 1, alpha = 1, arrow = FALSE,
arrow_type = NA, arrow_size = NA, two_way = FALSE, lavaan = FALSE,
line_style = 'solid'
)

csv_to_ggplot(points_data = points_data,
              lines_data = lines_data,
              zoom_level = 1.4, # From the ggsem app
              horizontal_position = 14, # From the ggsem app
              element_order = c('lines', 'points')) # order priority: lines < points


}
