% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-colour.R, R/zxx.R
\name{scale_colour_continuous}
\alias{scale_colour_continuous}
\alias{scale_fill_continuous}
\alias{scale_colour_binned}
\alias{scale_fill_binned}
\alias{scale_color_continuous}
\alias{scale_color_binned}
\title{Continuous and binned colour scales}
\usage{
scale_colour_continuous(
  ...,
  palette = NULL,
  aesthetics = "colour",
  guide = "colourbar",
  na.value = "grey50",
  type = getOption("ggplot2.continuous.colour")
)

scale_fill_continuous(
  ...,
  palette = NULL,
  aesthetics = "fill",
  guide = "colourbar",
  na.value = "grey50",
  type = getOption("ggplot2.continuous.fill")
)

scale_colour_binned(
  ...,
  palette = NULL,
  aesthetics = "colour",
  guide = "coloursteps",
  na.value = "grey50",
  type = getOption("ggplot2.binned.colour")
)

scale_fill_binned(
  ...,
  palette = NULL,
  aesthetics = "fill",
  guide = "coloursteps",
  na.value = "grey50",
  type = getOption("ggplot2.binned.fill")
)
}
\arguments{
\item{...}{Additional parameters passed on to the scale type}

\item{palette}{One of the following:
\itemize{
\item \code{NULL} for the default palette stored in the theme.
\item a character vector of colours.
\item a single string naming a palette.
\item a palette function that when called with a numeric vector with values
between 0 and 1 returns the corresponding output values.
}}

\item{aesthetics}{The names of the aesthetics that this scale works with.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[=guides]{guides()}} for more information.}

\item{na.value}{Missing values will be replaced with this value.}

\item{type}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} One of the following:
\itemize{
\item "gradient" (the default)
\item "viridis"
\item A function that returns a continuous colour scale.
}}
}
\description{
The scales \code{scale_colour_continuous()} and \code{scale_fill_continuous()} are
the default colour scales ggplot2 uses when continuous data values are
mapped onto the \code{colour} or \code{fill} aesthetics, respectively. The scales
\code{scale_colour_binned()} and \code{scale_fill_binned()} are equivalent scale
functions that assign discrete color bins to the continuous values
instead of using a continuous color spectrum.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}: The mechanism of setting defaults via
\code{\link[=options]{options()}} is superseded by theme settings. The preferred method to change
the default palette of scales is via the theme, for example:
\code{theme(palette.colour.continuous = scales::pal_viridis())}. The
\code{ggplot2.continuous.colour} and \code{ggplot2.continuous.fill} options could be
used to set default continuous scales and \code{ggplot2.binned.colour} and
\code{ggplot2.binned.fill} options to set default binned scales.

These scale functions are meant to provide simple defaults. If
you want to manually set the colors of a scale, consider using
\code{\link[=scale_colour_gradient]{scale_colour_gradient()}} or \code{\link[=scale_colour_steps]{scale_colour_steps()}}.
}
\section{Color Blindness}{

Many color palettes derived from RGB combinations (like the "rainbow" color
palette) are not suitable to support all viewers, especially those with
color vision deficiencies. Using \code{viridis} type, which is perceptually
uniform in both colour and black-and-white display is an easy option to
ensure good perceptive properties of your visualizations.
The colorspace package offers functionalities
\itemize{
\item to generate color palettes with good perceptive properties,
\item to analyse a given color palette, like emulating color blindness,
\item and to modify a given color palette for better perceptivity.
}

For more information on color vision deficiencies and suitable color choices
see the \href{https://arxiv.org/abs/1903.06490}{paper on the colorspace package}
and references therein.
}

\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy, colour = cty)) +
  geom_point()

# You can use the scale to give a palette directly
p + scale_colour_continuous(palette = c("#FEE0D2", "#FC9272", "#DE2D26"))

# The default colours are encoded into the theme
p + theme(palette.colour.continuous = c("#DEEBF7", "#9ECAE1", "#3182BD"))

# You can globally set default colour palette via the theme
old <- update_theme(palette.colour.continuous = c("#E5F5E0", "#A1D99B", "#31A354"))

# Plot now shows new global default
p

# The default binned colour scale uses the continuous palette
p + scale_colour_binned() +
  theme(palette.colour.continuous = c("#EFEDF5", "#BCBDDC", "#756BB1"))

# Restoring the previous theme
theme_set(old)
}
\seealso{
\code{\link[=scale_colour_gradient]{scale_colour_gradient()}}, \code{\link[=scale_colour_viridis_c]{scale_colour_viridis_c()}},
\code{\link[=scale_colour_steps]{scale_colour_steps()}}, \code{\link[=scale_colour_viridis_b]{scale_colour_viridis_b()}}, \code{\link[=scale_fill_gradient]{scale_fill_gradient()}},
\code{\link[=scale_fill_viridis_c]{scale_fill_viridis_c()}}, \code{\link[=scale_fill_steps]{scale_fill_steps()}}, and \code{\link[=scale_fill_viridis_b]{scale_fill_viridis_b()}}

The documentation on \link[=aes_colour_fill_alpha]{colour aesthetics}.

The \href{https://ggplot2-book.org/scales-colour#sec-colour-continuous}{continuous colour scales section} of the online ggplot2 book.

Other colour scales: 
\code{\link{scale_alpha}()},
\code{\link{scale_colour_brewer}()},
\code{\link{scale_colour_gradient}()},
\code{\link{scale_colour_grey}()},
\code{\link{scale_colour_hue}()},
\code{\link{scale_colour_identity}()},
\code{\link{scale_colour_manual}()},
\code{\link{scale_colour_steps}()},
\code{\link{scale_colour_viridis_d}()}
}
\concept{colour scales}
