% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes.r
\name{aes}
\alias{aes}
\title{Construct aesthetic mappings}
\usage{
aes(x, y, ...)
}
\arguments{
\item{x, y, ...}{List of name-value pairs in the form \code{aesthetic = variable}
describing which variables in the layer data should be mapped to which
aesthetics used by the paired geom/stat. The expression \code{variable} is
evaluated within the layer data, so there is no need to refer to
the original dataset (i.e., use \code{ggplot(df, aes(variable))}
instead of \code{ggplot(df, aes(df$variable))}). The names for x and y aesthetics
are typically omitted because they are so common; all other aesthetics must be named.}
}
\value{
A list with class \code{uneval}. Components of the list are either
quosures or constants.
}
\description{
Aesthetic mappings describe how variables in the data are mapped to visual
properties (aesthetics) of geoms. Aesthetic mappings can be set in
\code{\link[=ggplot]{ggplot()}} and in individual layers.
}
\details{
This function also standardises aesthetic names by converting \code{color} to \code{colour}
(also in substrings, e.g., \code{point_color} to \code{point_colour}) and translating old style
R names to ggplot names (e.g., \code{pch} to \code{shape} and \code{cex} to \code{size}).
}
\section{Quasiquotation}{


\code{aes()} is a \link[rlang:topic-defuse]{quoting function}. This means that
its inputs are quoted to be evaluated in the context of the
data. This makes it easy to work with variables from the data frame
because you can name those directly. The flip side is that you have
to use \link[rlang:topic-inject]{quasiquotation} to program with
\code{aes()}. See a tidy evaluation tutorial such as the \href{https://dplyr.tidyverse.org/articles/programming.html}{dplyr programming vignette}
to learn more about these techniques.
}

\examples{
aes(x = mpg, y = wt)
aes(mpg, wt)

# You can also map aesthetics to functions of variables
aes(x = mpg ^ 2, y = wt / cyl)

# Or to constants
aes(x = 1, colour = "smooth")

# Aesthetic names are automatically standardised
aes(col = x)
aes(fg = x)
aes(color = x)
aes(colour = x)

# aes() is passed to either ggplot() or specific layer. Aesthetics supplied
# to ggplot() are used as defaults for every layer.
ggplot(mpg, aes(displ, hwy)) + geom_point()
ggplot(mpg) + geom_point(aes(displ, hwy))

# Tidy evaluation ----------------------------------------------------
# aes() automatically quotes all its arguments, so you need to use tidy
# evaluation to create wrappers around ggplot2 pipelines. The
# simplest case occurs when your wrapper takes dots:
scatter_by <- function(data, ...) {
  ggplot(data) + geom_point(aes(...))
}
scatter_by(mtcars, disp, drat)

# If your wrapper has a more specific interface with named arguments,
# you need the "embrace operator":
scatter_by <- function(data, x, y) {
  ggplot(data) + geom_point(aes({{ x }}, {{ y }}))
}
scatter_by(mtcars, disp, drat)

# Note that users of your wrapper can use their own functions in the
# quoted expressions and all will resolve as it should!
cut3 <- function(x) cut_number(x, 3)
scatter_by(mtcars, cut3(disp), drat)
}
\seealso{
\code{\link[=vars]{vars()}} for another quoting function designed for
faceting specifications.
}
