\name{geom_boxplot}
\alias{geom_boxplot}
\alias{GeomBoxplot}
\title{geom\_boxplot}
\description{Box and whiskers plot}
\details{
This page describes geom\_boxplot, see \code{\link{layer}} and \code{\link{qplot}} for how to create a complete plot from individual components.
}
\section{Aesthetics}{
The following aesthetics can be used with geom\_boxplot.  Aesthetics are mapped to variables in the data with the \code{\link{aes}} function: \code{geom\_boxplot(\code{\link{aes}}(x = var))}
\itemize{
  \item \code{x}: x position (\strong{required}) 
  \item \code{min}: minimum of interval (\strong{required}) 
  \item \code{max}: maximum of interval (\strong{required}) 
  \item \code{weight}: observation weight used in statistical transformation 
  \item \code{colour}: border colour 
  \item \code{fill}: internal colour 
  \item \code{size}: size 
}
}
\usage{geom_boxplot(mapping=NULL, data=NULL, stat="boxplot", position="dodge", outlier.colour="black", outlier.shape=19, outlier.size=1, ...)}
\arguments{
 \item{mapping}{mapping between variables and aesthetics generated by aes}
 \item{data}{dataset used in this layer, if not specified uses plot dataset}
 \item{stat}{statistic used by this layer}
 \item{position}{position adjustment used by this layer}
 \item{outlier.colour}{colour for outlying points}
 \item{outlier.shape}{shape of outlying points}
 \item{outlier.size}{size of outlying points}
 \item{...}{other arguments}
}
\seealso{\itemize{
  \item \code{\link{stat_quantile}}: View quantiles conditioned on a continuous variable
  \item \code{\link{geom_jitter}}: Another way to look at conditional distributions
  \item \url{http://had.co.nz/ggplot/geom_boxplot.html}
}}
\value{A \code{\link{layer}}}
\examples{\dontrun{
    p <- ggplot(mtcars, aes(y=mpg, x=factor(cyl)))
    
    p + geom_boxplot()
    p + stat_boxplot()
    p + geom_boxplot() + geom_jitter()
    p + geom_boxplot() + coord_flip()
    
    p + geom_boxplot(outlier.colour = "green", outlier.size = 3)
    
    # Add aesthetic mappings
    p + geom_boxplot(aes(fill=cyl))
    p + geom_boxplot(aes(fill=factor(cyl)))
    p + geom_boxplot(aes(colour=cyl), size=1)
    
    # Dodged boxplots
    # - automatically split when an aesthetic variable is a factor
    p + geom_boxplot(aes(colour=factor(am)))
    p + geom_boxplot(aes(fill=factor(vs)), colour="black")
    p + geom_boxplot(aes(size=factor(gear)))
    
    # Set aesthetics to fixed value
    p + geom_boxplot(fill="black", colour="white", size=1)

    # Scales vs. Coordinate transforms
    m <- ggplot(movies, aes(y=votes, x=rating, group=round_any(rating,0.5)))
    m + geom_point()
    m + geom_boxplot()
    m + geom_boxplot() + scale_y_log10()
    m + geom_boxplot() + coord_trans(y="log10")
    m + geom_boxplot() + scale_y_log10() + coord_trans(y="log10")
    
    # Boxplots with continuous x
    qplot(year, budget, data=movies, geom="boxplot")
    qplot(year, budget, data=movies, geom="boxplot", group=year)
    qplot(year, budget, data=movies, geom="boxplot", group=round_any(year, 10, floor))
    
    # Use qplot instead
    qplot(factor(cyl), mpg, data=mtcars, geom="boxplot")
    qplot(factor(cyl), mpg, data=mtcars, geom="boxplot") + coord_flip()
}}
\author{Hadley Wickham, \url{http://had.co.nz/}}
\keyword{hplot}
