% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_ordicluster.R
\name{gg_ordicluster}
\alias{gg_ordicluster}
\title{Add Dendrogram to Ordination Plot}
\usage{
gg_ordicluster(
  ord,
  cluster,
  treatments = NA,
  choices = c(1, 2),
  prune = 0,
  col = 1,
  pt.size = 3,
  plot = TRUE
)
}
\arguments{
\item{ord}{An ordination object.}

\item{cluster}{A cluster object from 'hclust' based on the same distance as 'ord.'}

\item{treatments}{A vector assigning treatments to samples.}

\item{choices}{Ordination axes to be plotted.}

\item{prune}{Number of upper level hierarchies removed from the dendrogram. If prune > 0, dendrogram will be disconnected.}

\item{col}{A vector of cluster group memberships. Used to assign colors to line segments for each cluster group.}

\item{pt.size}{Symbol size.}

\item{plot}{A logical; defaults to TRUE.}
}
\value{
Invisibly returns a list of the data frames used to make the plot (df_ord, df_segments) and the plot itself (plot).
}
\description{
Modeled after the ordicluster function in vegan, this function overlays an ordination object with a cluster dendogram. Functionality has been added to include treatment groups.
}
\details{
'treatments' should be a vector of class factor and length equal to the number of samples included in the ordination and cluster; integers are not coerced into factors.
}
\examples{
data(dune)
data(dune.env)
dune.bray <- vegdist(dune, method="bray")
ord <- metaMDS(dune, k=3)
cl <- hclust(dune.bray, method="complete")
gg_ordicluster(ord, cluster=cl, treatments=dune.env$Management, prune=3, col=cutree(cl, 4))

}
\author{
Jari Oksanen, John Quensen
}
