% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ggs_ppmean.R
\name{ggs_ppmean}
\alias{ggs_ppmean}
\title{Posterior predictive plot comparing the outcome mean vs the distribution of the predicted posterior means.}
\usage{
ggs_ppmean(D, outcome, family = NA, bins = 30)
}
\arguments{
\item{D}{Data frame whith the simulations. Notice that only the posterior outcomes are needed, and so either the ggs() call limits the parameters to the outcomes or the user provides a family of parameters to limit it.}

\item{outcome}{vector (or matrix or array) containing the observed outcome variable. Currently only a vector is supported.}

\item{family}{Name of the family of parameters to plot, as given by a character vector or a regular expression. A family of parameters is considered to be any group of parameters with the same name but different numerical value between square brackets (as beta[1], beta[2], etc).}

\item{bins}{integer indicating the total number of bins in which to divide the histogram. Defaults to 30, which is the same as geom_histogram()}
}
\value{
A \code{ggplot} object.
}
\description{
Histogram with the distribution of the predicted posterior means, compared with the mean of the observed outcome.
}
\examples{
data(linear)
ggs_ppmean(ggs(s.y.rep), outcome=y)
}

