% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ggs_autocorrelation.R
\name{ac}
\alias{ac}
\title{Calculate the autocorrelation of a single chain, for a specified amount of lags}
\usage{
ac(x, nLags)
}
\arguments{
\item{x}{Vector with a chain of simulated values.}

\item{nLags}{Numerical value with the maximum number of lags to take into account.}
}
\value{
A matrix with the autocorrelations of every chain.
}
\description{
Calculate the autocorrelation of a single chain, for a specified amount of lags.
}
\details{
Internal function used by \code{\link{ggs_autocorrelation}}.
}
\examples{
# Calculate the autocorrelation of a simple vector
ac(cumsum(rnorm(10))/10, nLags=4)
}

