% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapdist.R
\name{mapdist}
\alias{mapdist}
\alias{distQueryCheck}
\title{Compute map distances using Google}
\usage{
mapdist(
  from,
  to,
  mode = c("driving", "walking", "bicycling", "transit"),
  output = c("simple", "all"),
  urlonly = FALSE,
  override_limit = FALSE,
  ext = "com",
  inject = "",
  ...
)

distQueryCheck()
}
\arguments{
\item{from}{name of origin addresses in a data frame (vector accepted), or a
data frame with from and to columns}

\item{to}{name of destination addresses in a data frame (vector accepted)}

\item{mode}{driving, bicycling, walking, or transit}

\item{output}{amount of output}

\item{urlonly}{return only the url?}

\item{override_limit}{override the current query count
(.google_distance_query_times)}

\item{ext}{top level domain domain extension (e.g. "com", "co.nz")}

\item{inject}{character string to add to the url}

\item{...}{...}
}
\value{
a data frame (output="simple") or all of the geocoded information
(output="all")
}
\description{
Compute map distances using Google's Distance Matrix API. Note: To use
Google's Distance Matrix API, you must first enable the API in the Google
Cloud Platform Console. See \code{\link[=register_google]{register_google()}}.
}
\details{
if parameters from and to are specified as geographic coordinates,
they are reverse geocoded with revgeocode.  note that the google maps api
limits to 2500 element queries a day.
}
\examples{

\dontrun{ requires Google API key, see ?register_google

## basic usage
########################################

mapdist("waco, texas", "houston, texas")


# many from, single to
from <- c("houston, texas", "dallas")
to <- "waco, texas"
mapdist(from, to)
mapdist(from, to, mode = "bicycling")
mapdist(from, to, mode = "walking")


# tibble of from's, vector of to's
# (with a data frame, remember stringsAsFactors = FALSE)
tibble(
  "from" = c("houston", "houston", "dallas"),
    "to" = c("waco", "san antonio", "houston")
) \%>\% mapdist()


# distance matrix
library("tidyverse")
c("Hamburg, Germany", "Stockholm, Sweden", "Copenhagen, Denmark") \%>\%
  list(., .) \%>\%
  set_names(c("from", "to")) \%>\%
  cross_df() \%>\%
  mapdist() -> distances

distances

distances \%>\%
  select(from, to, km) \%>\%
  spread(from, km)





## other examples
########################################

# many from, single to with addresses
from <- c(
  "1600 Amphitheatre Parkway, Mountain View, CA",
  "3111 World Drive Walt Disney World, Orlando, FL"
)
to <- "1600 Pennsylvania Avenue, Washington DC"
mapdist(from, to)


# mode = "transit
from <- "st lukes hospital houston texas"
to <- "houston zoo, houston texas"
mapdist(from, to, mode = "transit")





## geographic coordinates are accepted as well
########################################
(wh <- as.numeric(geocode("the white house, dc")))
(lm <- as.numeric(geocode("lincoln memorial washington dc")))
mapdist(wh, lm, mode = "walking")

}

}
\seealso{
\url{https://developers.google.com/maps/documentation/distance-matrix/},
\url{https://developers.google.com/maps/documentation/distance-matrix/overview/}
}
\author{
David Kahle \email{david@kahle.io}
}
