% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation_raster_interactive.R
\name{annotation_raster_interactive}
\alias{annotation_raster_interactive}
\title{Create interactive raster annotations}
\usage{
annotation_raster_interactive(...)
}
\arguments{
\item{...}{arguments passed to base function,
plus any of the \code{\link[=interactive_parameters]{interactive_parameters()}}..}
}
\description{
The layer is based on \code{\link[=annotation_raster]{annotation_raster()}}.
See the documentation for that function for more details.
}
\section{Details for annotate_*_interactive functions}{

The interactive parameters can be supplied as arguments in the relevant function
and they can be scalar values or vectors depending on params on base function.
}

\examples{
# add interactive raster annotation to a ggplot -------
library(ggplot2)
library(ggiraph)

# Generate data
rainbow <- matrix(hcl(seq(0, 360, length.out = 50 * 50), 80, 70), nrow = 50)
p <- ggplot(mtcars, aes(mpg, wt)) +
  geom_point() +
  annotation_raster_interactive(rainbow, 15, 20, 3, 4, tooltip = "I am an image!")
x <- girafe(ggobj = p)
if( interactive() ) print(x)

# To fill up whole plot
p <- ggplot(mtcars, aes(mpg, wt)) +
  annotation_raster_interactive(rainbow, -Inf, Inf, -Inf, Inf, tooltip = "I am an image too!") +
  geom_point()
x <- girafe(ggobj = p)
if( interactive() ) print(x)
}
\seealso{
\code{\link[=girafe]{girafe()}}
}
