% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_function_helpers.R
\name{layer_factory}
\alias{layer_factory}
\title{Create a ggformula layer function}
\usage{
layer_factory(geom = "point", position = "identity", stat = "identity",
  pre = { }, aes_form = y ~ x, extras = alist(), note = NULL,
  aesthetics = aes(), inherit.aes = TRUE, data = NULL,
  layer_fun = ggplot2::layer)
}
\arguments{
\item{geom}{The geom to use for the layer
(may be specified as a string).}

\item{position}{The position function to use for the layer
(may be specified as a string).}

\item{stat}{The stat function to use for the layer
(may be specified as a string).}

\item{pre}{code to run as a "pre-process".}

\item{aes_form}{A single formula or a list of formulas specifying
how attributes are inferred from the formula.  Use \code{NULL} if the
funciton may be used without a formula.}

\item{extras}{An alist of additional arguments (potentially with defaults)}

\item{note}{A note to add to the quick help.}

\item{aesthetics}{Additional aesthetics (typically created using
\code{\link[ggplot2:aes]{ggplot2::aes()}}) set rather than inferred from formula.
\code{gf_dhistogram()} uses this to set the y aesthetic to \code{stat(density)},
for example.}

\item{inherit.aes}{A logical indicating whether aesthetics should be
inherited from prior layers.}

\item{data}{A data frame or \code{NULL} or \code{NA}.}

\item{layer_fun}{The function used to create the layer.}
}
\value{
A function.
}
\description{
Primarily intended for package developers, this function factory
is used to create the layer functions in the ggformula package.
}
