% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabel.R
\name{get_variable_labels}
\alias{get_variable_labels}
\title{Set and extract labels from a labeled object}
\usage{
get_variable_labels(...)
}
\arguments{
\item{...}{passed to \code{\link[labelled:var_label]{labelled::var_label()}}}
}
\description{
Some packages like expss provide mechanisms for providing longer labels to R objects.
These labels can be used when labeling plots and tables, for example, without requiring
long or awkward variable names.  This is an experimental feature and currently only supports
expss or any other system that stores a label in the \code{label} attribute of a vector.
}
\details{
\code{get_variable_labels()} is a synonym of \code{\link[labelled:var_label]{labelled::var_label()}}.
}
\examples{
KF <-
  mosaicData::KidsFeet \%>\%
  set_variable_labels(
      length      = 'foot length (cm)',
      width       = 'foot width (cm)',
      birthmonth  = 'birth month',
      birthyear   = 'birth year',
      biggerfoot  = 'bigger foot',
      domhand     = 'dominant hand'
  )
KF \%>\%
  gf_point(length ~ width, color = ~ domhand)
get_variable_labels(KF)
}
\seealso{
\code{\link[labelled:var_label]{labelled::var_label()}}, \code{\link[labelled:var_label]{labelled::set_variable_labels()}}
}
