% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_fit_text.R
\name{geom_fit_text}
\alias{geom_fit_text}
\title{A 'ggplot2' geom to fit text inside a box}
\usage{
geom_fit_text(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, padding.x = grid::unit(1, "mm"),
  padding.y = grid::unit(0.1, "lines"), place = "centre", min.size = 4,
  grow = FALSE, reflow = FALSE, width = grid::unit(40, "mm"),
  height = grid::unit(40, "mm"), ...)
}
\arguments{
\item{mapping}{\code{ggplot2::aes()} object as standard in 'ggplot2'. Note
that aesthetics specifying the box must be provided. See Details.}

\item{data, stat, position, na.rm, show.legend, inherit.aes, ...}{Standard geom
arguments as for \code{ggplot2::geom_text()}.}

\item{padding.x, padding.y}{Amount of horizontal and vertical padding around
the text, expressed as \code{grid::unit()} objects. Default to 1 mm and 0.1
lines respectively.}

\item{place}{Where inside the box to place the text. Default is 'centre';
other options are 'topleft', 'top', 'topright', etc.}

\item{min.size}{Minimum font size, in points. If provided, text that would
need to be shrunk below this size to fit the box will not be drawn. Defaults
to 4 pt.}

\item{grow}{If 'TRUE', text will be grown as well as shrunk to fill the box.
See Details.}

\item{reflow}{If 'TRUE', text will be reflowed (wrapped) to better fit the
box. See Details.}

\item{width, height}{When using `x` and/or `y` aesthetics, these will be used
to determine the width and/or height of the box. These should be
either numeric values on the \code{x} and \code{y} scales or
\code{grid::unit()} objects. Both default to 40 mm units.}
}
\description{
\code{geom_fit_text} shrinks, grows or wraps text to fit inside a defined
rectangular area.
}
\details{
Except where noted, \code{geom_fit_text} behaves more or less like
\code{ggplot2::geom_text}.

In addition to the normal \code{geom_text} aesthetics, \code{geom_fit_text}
requires you to specify the box in which you wish to fit the text, usually
with 'xmin', 'xmax', 'ymin' and 'ymax' aesthetics. Alternatively, you can
specify the centre of the box with 'x' and/or 'y', and the height and/or
width of the box with 'height' and/or 'width' arguments. This can be useful
when one or both axes are discrete. 'height' and 'width' should be provided
as `grid::unit()` objects, and both default to 40 mm.

By default, the text will be drawn as if with \code{geom_text}, unless it is
too big for the box, in which case it will be shrunk to fit the box. With
\code{grow = TRUE}, the text will be made to fill the box completely whether
that requires shrinking or growing.

\code{reflow = TRUE} will cause the text to be reflowed (wrapped) to better
fit in the box. When \code{grow = FALSE} (default), text that fits the box
will be drawn as if with \code{geom_text}; text that doesn't fit the box will
be reflowed until it does. If the text cannot be made to fit by reflowing
alone, it will be reflowed to match the aspect ratio of the box as closely as
possible, then be shrunk to fit the box. When \code{grow = TRUE}, the text
will be reflowed to best match the aspect ratio of the box, then made to fill
the box completely whether that requires growing or shrinking. Existing line
breaks ('\\n') in the text will be respected when reflowing.
}
\section{Aesthetics}{


\itemize{
  \item label (required)
  \item xmin, xmax OR x (required)
  \item ymin, ymax OR y (required)
  \item alpha
  \item angle
  \item colour
  \item family
  \item fontface
  \item lineheight
  \item size
}
}

\examples{

ggplot2::ggplot(ggplot2::presidential, ggplot2::aes(ymin = start, ymax = end,
    label = name, fill = party, xmin = 0, xmax = 1)) +
  ggplot2::geom_rect(colour = 'black') +
  geom_fit_text(grow = TRUE)

}
