% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdmc_utils.R
\name{mcmc.list.dmc}
\alias{mcmc.list.dmc}
\title{Create a mcmc.list in DMC format}
\usage{
mcmc.list.dmc(samples, hyper = FALSE, start = 1, end = NA,
  save.ll = FALSE, ask = TRUE, main.pll = NULL, pll.chain = FALSE,
  pll.together = TRUE, pll.barplot = FALSE, only.prior = FALSE,
  only.like = FALSE, subject = 1, layout = NA, ...)
}
\arguments{
\item{samples}{a data frame stored choice-RT data}

\item{hyper}{a DMC model}

\item{start}{starting iteration}

\item{end}{end iteration}

\item{save.ll}{whether save log likelihood}

\item{ask}{Default TRUE}

\item{main.pll}{Default NULL}

\item{pll.chain}{Default FALSE}

\item{pll.together}{Default TRUE}

\item{pll.barplot}{Default FALSE}

\item{only.prior}{plot only prior distribution}

\item{only.like}{plot only likelihood}

\item{subject}{plot which participant. Default the 1st}

\item{layout}{graphic layout. Default NA}

\item{...}{other arguments}
}
\description{
If not hyper, by default changes samples$theta to a mcmc.list object and
plots If pll.chain=TRUE changes samples$pll to an mcmc object and plots
posterior log-likelihood of chains. If pll.barplot=TRUE plots their means
as a barplot. only.prior and only.like pick out one or other component of
pll. If hyper same but at the the hyper  (phi) level.
}

