% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_dag.R
\name{DAG Edges}
\alias{DAG Edges}
\alias{geom_dag_edges_link}
\alias{geom_dag_edges_arc}
\alias{geom_dag_edges_diagonal}
\alias{geom_dag_edges_fan}
\title{Directed DAG edges}
\usage{
geom_dag_edges_link(
  mapping = NULL,
  data = NULL,
  arrow = grid::arrow(length = grid::unit(5, "pt"), type = "closed"),
  position = "identity",
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_dag_edges_arc(
  mapping = NULL,
  data = NULL,
  curvature = 0.5,
  arrow = grid::arrow(length = grid::unit(5, "pt"), type = "closed"),
  position = "identity",
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  fold = FALSE,
  n = 100,
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  label_colour = "black",
  label_alpha = 1,
  label_parse = FALSE,
  check_overlap = FALSE,
  angle_calc = "rot",
  force_flip = TRUE,
  label_dodge = NULL,
  label_push = NULL,
  ...
)

geom_dag_edges_diagonal(
  mapping = NULL,
  data = NULL,
  position = "identity",
  arrow = grid::arrow(length = grid::unit(5, "pt"), type = "closed"),
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  curvature = 1,
  n = 100,
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  label_colour = "black",
  label_alpha = 1,
  label_parse = FALSE,
  check_overlap = FALSE,
  angle_calc = "rot",
  force_flip = TRUE,
  label_dodge = NULL,
  label_push = NULL,
  ...
)

geom_dag_edges_fan(
  mapping = NULL,
  data = NULL,
  position = "identity",
  arrow = grid::arrow(length = grid::unit(5, "pt"), type = "closed"),
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  spread = 0.7,
  n = 100,
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  label_colour = "black",
  label_alpha = 1,
  label_parse = FALSE,
  check_overlap = FALSE,
  angle_calc = "rot",
  force_flip = TRUE,
  label_dodge = NULL,
  label_push = NULL,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by aes() or aes_(). If
specified and inherit.aes = TRUE (the default), it is combined with the
default mapping at the top level of the plot. You must supply mapping if
there is no plot mapping.}

\item{data}{The data to be displayed in this layer.
There are three options: If NULL, the default, the data is inherited from
the plot data as specified in the call to ggplot(). A data.frame, or other
object, will override the plot data. All objects will be fortified to
produce a data frame. See fortify() for which variables will be created. A
function will be called with a single argument, the plot data. The return
value must be a data.frame., and will be used as the layer data.}

\item{arrow}{specification for arrow heads, as created by arrow()}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{na.rm}{If FALSE (the default), removes missing values with a warning.
If TRUE silently removes missing values}

\item{show.legend}{logical. Should this layer be included in the legends? NA,
the default, includes if any aesthetics are mapped. FALSE never includes,
and TRUE always includes. It can also be a named logical vector to finely
select the aesthetics to display.}

\item{inherit.aes}{If FALSE, overrides the default aesthetics, rather than
combining with them. This is most useful for helper functions that define
both data and aesthetics and shouldn't inherit behaviour from the default
plot specification, e.g. borders().}

\item{...}{Other arguments passed to ggraph::geom_edge_*()}

\item{curvature}{The bend of the curve. 1 approximates a halfcircle while 0
will give a straight line. Negative number will change the direction of the
curve. Only used if layout circular = FALSE.}

\item{fold}{Logical. Should arcs appear on the same side of the nodes despite
different directions. Default to FALSE.}

\item{n}{The number of points to create along the path.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{label_colour}{The colour of the edge label. If \code{NA} it will use
the colour of the edge.}

\item{label_alpha}{The opacity of the edge label. If \code{NA} it will use
the opacity of the edge.}

\item{label_parse}{If \code{TRUE}, the labels will be parsed into expressions
and displayed as described in \code{\link[grDevices:plotmath]{grDevices::plotmath()}}.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_text()}. Note that this argument is not
supported by \code{geom_label()}.}

\item{angle_calc}{Either 'none', 'along', or 'across'. If 'none' the label will
use the angle aesthetic of the geom. If 'along' The label will be written
along the edge direction. If 'across' the label will be written across the
edge direction.}

\item{force_flip}{Logical. If \code{angle_calc} is either 'along' or 'across'
should the label be flipped if it is on it's head. Default to \code{TRUE}.}

\item{label_dodge}{A \code{\link[grid:unit]{grid::unit()}} giving a fixed vertical shift
to add to the label in case of \code{angle_calc} is either 'along' or 'across'}

\item{label_push}{A \code{\link[grid:unit]{grid::unit()}} giving a fixed horizontal shift
to add to the label in case of \code{angle_calc} is either 'along' or 'across'}

\item{spread}{Deprecated. Use \code{strength} instead.}
}
\description{
Directed DAG edges
}
\section{Aesthetics}{

\code{geom_dag_edges_link}, \code{geom_dag_edges_arc}, \code{geom_dag_edges_diagonal}, and
\code{geom_dag_edges_fan} understand the following aesthetics. Bold aesthetics are
required.
\itemize{
\item \strong{x}
\item \strong{y}
\item \strong{xend}
\item \strong{yend}
\item edge_colour
\item edge_width
\item edge_linetype
\item edge_alpha
\item start_cap
\item end_cap
\item label
\item label_pos
\item label_size
\item angle
\item hjust
\item vjust
\item family
\item fontface
\item lineheight
}

\code{geom_dag_edges_arc} and \code{geom_dag_edges_diagonal} also require
\strong{circular}, but this is automatically set.

\code{geom_dag_edges_fan} requires \strong{to} and \strong{from}, but these are also
automatically set.
}

\examples{
library(ggplot2)
p <- dagify(y ~ x + z2 + w2 + w1,
  x ~ z1 + w1,
  z1 ~ w1 + v,
  z2 ~ w2 + v,
  L ~ w1 + w2) \%>\%
  ggplot(aes(x = x, y = y, xend = xend, yend = yend)) +
    geom_dag_point() +
    geom_dag_text() +
    theme_dag()

p + geom_dag_edges_link()
p + geom_dag_edges_arc()
p + geom_dag_edges_diagonal()
p + geom_dag_edges_fan()

}
