% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_transcript.R
\name{geom_transcript}
\alias{geom_transcript}
\title{Add Transcript Annotation to Coverage Plot.}
\usage{
geom_transcript(
  gtf.gr,
  gene.name = "HNRNPC",
  overlap.tx.gap = 0.1,
  tx.size = 1,
  utr.size = 2,
  exon.size = 4,
  arrow.size = 1,
  color.by = "strand",
  fill.color = c(`-` = "darkblue", `+` = "darkgreen"),
  arrow.gap = NULL,
  arrow.num = 50,
  arrow.length = 0.06,
  label.size = 3,
  label.vjust = 2,
  plot.space = 0.1,
  plot.height = 1
)
}
\arguments{
\item{gtf.gr}{Granges object of GTF, created with \code{\link{import.gff}}. Default: NULL.}

\item{gene.name}{Gene name of all transcripts. Default: HNRNPC.}

\item{overlap.tx.gap}{The gap between transcript groups. Default: 0.1.}

\item{tx.size}{The line size of transcript. Default: 1.}

\item{utr.size}{The line size of UTR. Default: 2.}

\item{exon.size}{The line size of exon. Default: 4.}

\item{arrow.size}{The line size of arrow. Default: 1.}

\item{color.by}{Color the line by. Default: strand.}

\item{fill.color}{Color used for \code{color.by}.
Default: darkblue for - (minus strand), darkgreen for + (plus strand).}

\item{arrow.gap}{The gap distance between arrow. Default: NULL.}

\item{arrow.num}{Total arrow num of whole region. Default: 50.}

\item{arrow.length}{The length of arrow. Default: 0.06.}

\item{label.size}{The size of transcript label. Default: 3.}

\item{label.vjust}{The vjust of transcript label. Default: 2.}

\item{plot.space}{Top and bottom margin. Default: 0.1.}

\item{plot.height}{The relative height of transcript annotation to coverage plot. Default: 0.2.}
}
\value{
Plot.
}
\description{
Add Transcript Annotation to Coverage Plot.
}
\examples{
library(ggcoverage)
library(utils)
library(rtracklayer)
meta.file <- system.file("extdata", "RNA-seq", "meta_info.csv", package = "ggcoverage")
sample.meta <- utils::read.csv(meta.file)
# track folder
track.folder <- system.file("extdata", "RNA-seq", package = "ggcoverage")
# load bigwig file
track.df <- LoadTrackFile(
  track.folder = track.folder, format = "bw",
  meta.info = sample.meta
)
gtf.file <- system.file("extdata", "used_hg19.gtf", package = "ggcoverage")
gtf.gr <- rtracklayer::import.gff(con = gtf.file, format = "gtf")
basic.coverage <- ggcoverage(data = track.df, color = "auto", range.position = "out")
basic.coverage + geom_transcript(gtf.gr = gtf.gr, label.vjust = 1.5)
}
