% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_gc.R
\name{geom_gc}
\alias{geom_gc}
\title{Add GC Content Annotation to Coverage Plot.}
\usage{
geom_gc(
  fa.file = NULL,
  bs.fa.seq = NULL,
  chr.split = "[[:space:]]",
  guide.line = NULL,
  line.color = "black",
  guide.line.color = "red",
  guide.line.type = "dashed",
  plot.space = 0.1,
  plot.height = 0.2
)
}
\arguments{
\item{fa.file}{Genome fasta file. Default: NULL.}

\item{bs.fa.seq}{BSgenome for species. Default: NULL.}

\item{chr.split}{Split between chromosome name and description in \code{fa.file}. Default: "[[:space:]]".}

\item{guide.line}{GC content guide line. Default: NULL (use mean GC content).}

\item{line.color}{GC line color. Default: "black".}

\item{guide.line.color}{The color of guide line. Default: "red".}

\item{guide.line.type}{The line type of guide line. Default: "dashed".}

\item{plot.space}{Top and bottom margin. Default: 0.1.}

\item{plot.height}{The relative height of GC content annotation to coverage plot. Default: 0.2.}
}
\value{
Plot.
}
\description{
Add GC Content Annotation to Coverage Plot.
}
\examples{
library(ggcoverage)
library(utils)
library(rtracklayer)
library("BSgenome.Hsapiens.UCSC.hg19")
# track folder
track.file <- system.file("extdata", "DNA-seq", "CNV_example.txt", package = "ggcoverage")
track.df <- utils::read.table(track.file, header = TRUE)
gtf.file <- system.file("extdata", "used_hg19.gtf", package = "ggcoverage")
gtf.gr <- rtracklayer::import.gff(con = gtf.file, format = "gtf")
basic.coverage <- ggcoverage(
  data = track.df, color = NULL, mark.region = NULL,
  region = "chr4:61750000-62,700,000", range.position = "out"
)
basic.coverage + geom_gc(bs.fa.seq = BSgenome.Hsapiens.UCSC.hg19)
}
