% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_ggalign}
\alias{theme_ggalign}
\title{Complete theme for layout plots}
\usage{
theme_ggalign(...)
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:ggtheme]{ggplot2::theme_classic}}
  \describe{
    \item{\code{base_size}}{base font size, given in pts.}
    \item{\code{base_family}}{base font family}
    \item{\code{base_line_size}}{base size for line elements}
    \item{\code{base_rect_size}}{base size for rect elements}
  }}
}
\value{
A \link[ggplot2:theme]{theme} object.
}
\description{
Default theme for \code{\link[=heatmap_layout]{heatmap_layout()}} or \code{\link[=stack_layout]{stack_layout()}} object.
}
\details{
You can use the option \code{"ggalign.default_theme"}
to change the default theme.
}
\examples{
old <- options(ggalign.default_theme = theme_bw())
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("top") +
    align_dendro(k = 3L)
options(ggalign.default_theme = old)
}
