% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gg_partial.ggRandomForests}
\alias{gg_partial}
\alias{gg_partial.ggRandomForests}
\title{Partial variable dependence object}
\usage{
gg_partial.ggRandomForests(object, named, ...)
}
\arguments{
\item{object}{the partial variable dependence data object from
\code{randomForestSRC::plot.variable} function}

\item{named}{optional column for merging multiple plots together}

\item{...}{optional arguments}
}
\value{
A \code{data.frame} or \code{list} of data.frames corresponding the variables
contained within the \code{randomForestSRC::plot.variable} output.
}
\description{
The \code{randomForestSRC::plot.variable} function returns a
list of either marginal variable dependance or partial variable dependence
data from a \code{randomForestSRC::rfsrc} object.
The \code{gg_partial} function formulates the \code{randomForestSRC::plot.variable} output
for partial plots  (where partial=TRUE) into a data object for creation of
partial dependence plots using the \code{\link{plot.gg_partial}} function.

Partial variable dependence plots are the risk adjusted estimates of the specified response as a
function of a single covariate, possibly subsetted on other covariates.
}
\examples{
## ------------------------------------------------------------
## classification
## ------------------------------------------------------------

## iris "Petal.Width" partial dependence plot
##
# iris_rf <- rfsrc(Species ~., data = iris)
# iris_prtl <- plot.variable(iris_rf, xvar.names = "Petal.Width",
#                            partial=TRUE)
data(iris_prtl, package="ggRandomForests")

gg_dta <- gg_partial(iris_prtl)
plot(gg_dta)

## ------------------------------------------------------------
## regression
## ------------------------------------------------------------

## airquality "Wind" partial dependence plot
##
# airq_rf <- rfsrc(Ozone ~ ., data = airquality)
# airq_prtl <- plot.variable(airq_rf, xvar.names = "Wind",
#                            partial=TRUE, show.plot=FALSE)
data(airq_prtl, package="ggRandomForests")

gg_dta <- gg_partial(airq_prtl)
plot(gg_dta)

## ------------------------------------------------------------
## survival examples
## ------------------------------------------------------------
## survival "age" partial variable dependence plot
##
# data(veteran, package = "randomForestSRC")
# veteran_rf <- rfsrc(Surv(time,status)~., veteran, nsplit = 10, ntree = 100)
#
## 30 day partial plot for age
# veteran_prtl <- plot.variable(veteran_rf, surv.type = "surv",
#                               partial = TRUE, time=30,
#                               xvar.names = "age",
#                               show.plots=FALSE)
data(veteran_prtl, package="ggRandomForests")

gg_dta <- gg_partial(veteran_prtl)
plot(gg_dta)
}
\seealso{
\code{\link{plot.gg_partial}} \code{randomForestSRC::plot.variable}
}

