% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_ori_sca.R
\name{compute_ori_sca}
\alias{compute_ori_sca}
\title{Compute the origin and scale of the horizon plot}
\usage{
compute_ori_sca(data, origin, horizonscale)
}
\arguments{
\item{data}{A data frame.}

\item{origin}{Origin of the horizon plot. It can either be a string, namely
\code{"midpoint"} (the default), \code{"median"},
\code{"mean"}, \code{"min"} or \code{"quantiles"}, or a user-specified number.}

\item{horizonscale}{Cutpoints of the horizon plot. It can either be an integer
specifying the number of ranges (default is \code{6}),
or a user-supplied numeric vector with the cutpoints defining the different ranges.}
}
\value{
A list with two elements: \code{ori}, which represents the numeric
origin of the horizon plot, and \code{vec_cut}, which is a vector with the
cutpoints for the horizon plot.
}
\description{
Compute the origin and scale of the horizon plot
}
\keyword{internal}
