% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggInterval_PCA.r
\name{ggInterval_PCA}
\alias{ggInterval_PCA}
\title{Vertice-PCA for interval data}
\usage{
ggInterval_PCA(data = NULL,mapping = aes(NULL),plot=TRUE,
                      concepts_group=NULL, poly = FALSE, adjust = TRUE)
}
\arguments{
\item{data}{A ggESDA object. It can also be either RSDA object or
classical data frame, which will be automatically convert to ggESDA
data.}

\item{mapping}{Set of aesthetic mappings created by aes() or aes_().
If specified and inherit. aes = TRUE (the default),
it is combined with the default mapping at the top level of
the plot. You must supply mapping if there is no plot mapping.
It is the same as the mapping of ggplot2.}

\item{plot}{Boolean variable,Auto plot (if TRUE).It can also plot by
its inner object}

\item{concepts_group}{color with each group of concept}

\item{poly}{if plot a poly result}

\item{adjust}{adjust sign of the principal component}
}
\value{
A ggplot object for PC1,PC2,and a interval scores and others.
\itemize{
  \item scores_interval - The interval scores after PCA.
  \item ggplotPCA - a ggplot object with x-axis and y-axis are PC1 and
  PC2.
  \item others - others are the returns values of princomp.
}
}
\description{
ggInterval_PCA performs a principal components
analysis on the given numeric interval data and returns the
results like princomp, ggplot object and a interval scores.
}
\examples{
ggInterval_PCA(iris)

mydata2<-RSDA::Cardiological
ggInterval_PCA(mydata2,aes(col="red",alpha=0.2))

d<-mapply(c(10,20,40,80,160),c(20,40,80,160,320),FUN=runif,n=1000)
d<-data.frame(qq=matrix(d,ncol=4))
ggInterval_PCA(d)

myIris<-classic2sym(iris,Species)
p<-ggInterval_PCA(myIris,plot=FALSE)
p$ggplotPCA
p$scores_interval

}
