% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{gfiQuantile}
\alias{gfiQuantile}
\title{Quantiles of a fiducial distribution}
\usage{
gfiQuantile(parameter, gfi, probs)
}
\arguments{
\item{parameter}{a right-sided formula defining the parameter of interest, 
like \code{~ sigma_error/`(Intercept)`}}

\item{gfi}{a \code{gfilmm} object (output of \code{\link{gfilmm}} or 
\code{\link{gfilmmPredictive}})}

\item{probs}{numeric vector of probabilities}
}
\value{
Numeric vector of quantiles, of the same length as \code{probs}.
}
\description{
Quantiles of the fiducial distribution of a parameter of 
  interest.
}
\examples{
h <- 0.01
gfi <- gfilmm(
  ~ cbind(yield-h, yield+h), ~ 1, ~ block, data = npk, N = 5000, nthreads = 2
)
gfiQuantile(~ sqrt(sigma_block^2 + sigma_error^2), gfi, c(25, 50, 75)/100)
}
